/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.DependencyBinder;
import org.operamasks.faces.binding.impl.PropertyBinding;
import org.operamasks.faces.conversation.ConversationContext;
import org.operamasks.faces.developer.util.FacesUtils;

public class OutjectBinder
extends DependencyBinder {
    private String expr;
    private ManagedBeanScope scope;

    public OutjectBinder(String expr, ManagedBeanScope scope) {
        this.expr = expr;
        this.scope = scope;
    }

    public String getExpression() {
        return this.expr;
    }

    public ManagedBeanScope getScope() {
        return this.scope;
    }

    public void outject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
        Object value = binding.getModelValue(bean);
        if (value == null) {
            return;
        }
        if (FacesUtils.isValueExpression(this.expr)) {
            ValueExpression ve = FacesUtils.createValueExpression(bean, this.expr, binding.getType());
            ve.setValue(ctx.getELContext(), value);
        } else {
            ExternalContext ext = ctx.getExternalContext();
            if (this.scope == ManagedBeanScope.REQUEST) {
                ext.getRequestMap().put(this.expr, value);
            } else if (this.scope == ManagedBeanScope.SESSION) {
                ext.getSessionMap().put(this.expr, value);
            } else if (this.scope == ManagedBeanScope.APPLICATION) {
                ext.getApplicationMap().put(this.expr, value);
            } else if (this.scope == ManagedBeanScope.CONVERSATION) {
                ConversationContext.getCurrentInstance().put(this.expr, value);
            }
        }
    }
}

