/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.CompositeMethodAdapter;
import org.operamasks.faces.binding.impl.MethodAdapter;
import org.operamasks.faces.developer.util.FacesUtils;

public class PhaseListenerBinding
extends Binding {
    private Method beforePhaseMethod;
    private Method afterPhaseMethod;
    private Method beforeRenderMethod;
    private Method afterRenderMethod;
    private static final MethodInfo PhaseMethodInfo = new MethodInfo("phaseListener", Void.TYPE, new Class[]{PhaseEvent.class});

    public PhaseListenerBinding(String viewId) {
        super(viewId);
    }

    public Method getBeforePhaseMethod() {
        return this.beforePhaseMethod;
    }

    public void setBeforePhaseMethod(Method method) {
        method.setAccessible(true);
        this.beforePhaseMethod = BindingUtils.getInterfaceMethod(method);
    }

    public Method getAfterPhaseMethod() {
        return this.afterPhaseMethod;
    }

    public void setAfterPhaseMethod(Method method) {
        method.setAccessible(true);
        this.afterPhaseMethod = BindingUtils.getInterfaceMethod(method);
    }

    public Method getBeforeRenderMethod() {
        return this.beforeRenderMethod;
    }

    public void setBeforeRenderMethod(Method method) {
        method.setAccessible(true);
        this.beforeRenderMethod = BindingUtils.getInterfaceMethod(method);
    }

    public Method getAfterRenderMethod() {
        return this.afterRenderMethod;
    }

    public void setAfterRenderMethod(Method method) {
        method.setAccessible(true);
        this.afterRenderMethod = BindingUtils.getInterfaceMethod(method);
    }

    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        MethodAdapter binding;
        UIViewRoot view = ctx.getViewRoot();
        PhaseId phaseId = mbc.getPhaseId();
        ModelBean bean = mbc.getModelBean();
        if (this.beforePhaseMethod != null) {
            binding = new MethodAdapter(bean, this.beforePhaseMethod);
            this.applyBeforePhaseMethod(view, phaseId, binding);
        }
        if (this.afterPhaseMethod != null) {
            binding = new MethodAdapter(bean, this.afterPhaseMethod);
            this.applyAfterPhaseMethod(view, phaseId, binding);
        }
        if (this.beforeRenderMethod != null) {
            binding = new BeforeRenderMethodAdapter(bean, this.beforeRenderMethod);
            this.applyBeforePhaseMethod(view, phaseId, binding);
        }
        if (this.afterRenderMethod != null) {
            binding = new AfterRenderMethodAdapter(bean, this.afterRenderMethod);
            this.applyAfterPhaseMethod(view, phaseId, binding);
        }
    }

    private void applyBeforePhaseMethod(UIViewRoot view, PhaseId phaseId, MethodExpression binding) {
        CompositeMethodAdapter adapter;
        MethodExpression previous = view.getBeforePhaseListener();
        if (previous != null && !(previous instanceof CompositeMethodAdapter)) {
            return;
        }
        if (previous == null || phaseId != ((CompositeMethodAdapter)previous).getPhaseId()) {
            adapter = new CompositeMethodAdapter(PhaseMethodInfo);
            adapter.setPhaseId(phaseId);
            view.setBeforePhaseListener((MethodExpression)adapter);
        } else {
            adapter = (CompositeMethodAdapter)previous;
        }
        adapter.addMethodBinding(binding);
    }

    private void applyAfterPhaseMethod(UIViewRoot view, PhaseId phaseId, MethodExpression binding) {
        CompositeMethodAdapter adapter;
        MethodExpression previous = view.getAfterPhaseListener();
        if (previous != null && !(previous instanceof CompositeMethodAdapter)) {
            return;
        }
        if (previous == null || phaseId != ((CompositeMethodAdapter)previous).getPhaseId()) {
            adapter = new CompositeMethodAdapter(PhaseMethodInfo);
            adapter.setPhaseId(phaseId);
            view.setAfterPhaseListener((MethodExpression)adapter);
        } else {
            adapter = (CompositeMethodAdapter)previous;
        }
        adapter.addMethodBinding(binding);
    }

    private static class AfterRenderMethodAdapter
    extends MethodAdapter {
        public AfterRenderMethodAdapter(ModelBean bean, Method method) {
            super(bean, method);
        }

        public Object invoke(ELContext context, Object[] params) {
            assert (params.length == 1 && params[0] instanceof PhaseEvent);
            PhaseEvent event = (PhaseEvent)params[0];
            if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                return super.invoke(context, new Object[0]);
            }
            return null;
        }
    }

    private static class BeforeRenderMethodAdapter
    extends MethodAdapter {
        public BeforeRenderMethodAdapter(ModelBean bean, Method method) {
            super(bean, method);
        }

        public Object invoke(ELContext context, Object[] params) {
            assert (params.length == 1 && params[0] instanceof PhaseEvent);
            PhaseEvent event = (PhaseEvent)params[0];
            if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                boolean postBack = FacesUtils.isPostback(FacesContext.getCurrentInstance());
                return super.invoke(context, new Object[]{postBack});
            }
            return null;
        }
    }
}

