/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.faces.FacesException;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBinding
extends Binding {
    protected String name;
    protected Class<?> type;
    private Field field;
    private Method read;
    private Method write;
    private Method init;
    private Class<?> declaringClass;
    private Reader reader;
    private Writer writer;
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.binding");

    protected PropertyBinding(String viewId) {
        super(viewId);
    }

    public void init(Class<? extends Annotation> metaType, Class<?> targetClass, AnnotatedElement f) {
        Class<?> decl;
        Class<?> type;
        String name;
        Field field = null;
        Method read = null;
        Method write = null;
        if (f instanceof Field) {
            field = (Field)f;
            name = field.getName();
            type = field.getType();
            decl = field.getDeclaringClass();
        } else if (f instanceof Method) {
            Method method = (Method)f;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (methodName.startsWith("set") && paramTypes.length == 1 && returnType == Void.TYPE) {
                name = methodName.substring(3);
                type = paramTypes[0];
                write = method;
            } else if (methodName.startsWith("get") && paramTypes.length == 0 && returnType != Void.TYPE) {
                name = methodName.substring(3);
                type = returnType;
                read = method;
            } else if (methodName.startsWith("is") && paramTypes.length == 0 && returnType == Boolean.TYPE) {
                name = methodName.substring(2);
                type = returnType;
                read = method;
            } else {
                throw new FacesException(Resources._T("MVB_INVALID_ACCESSOR_METHOD", methodName));
            }
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            decl = method.getDeclaringClass();
        } else {
            throw new IllegalArgumentException();
        }
        this.init(metaType, name, type, targetClass, field, read, write);
        this.declaringClass = decl;
    }

    public void init(Class<? extends Annotation> metaType, String name, Class<?> type, Class<?> targetClass, Field field, Method read, Method write) {
        boolean bWrite;
        if (read == null) {
            read = BindingUtils.getReadMethod(targetClass, name, type);
        }
        if (write == null) {
            write = BindingUtils.getWriteMethod(targetClass, name, type);
        }
        boolean bRead = read != null && BindingUtils.isBindingPresent(targetClass, read, metaType);
        boolean bl = bWrite = write != null && BindingUtils.isBindingPresent(targetClass, write, metaType);
        if (field != null && (bRead || bWrite)) {
            throw new FacesException(Resources._T("MVB_BIND_FIELD_AND_METHOD", name));
        }
        if (bRead && bWrite) {
            throw new FacesException(Resources._T("MVB_BIND_READ_AND_WRITE", name));
        }
        this.setName(name);
        this.setType(type);
        if (read != null) {
            read.setAccessible(true);
            this.read = read = BindingUtils.getInterfaceMethod(read);
            this.reader = new MethodReader(read);
        }
        if (write != null) {
            write.setAccessible(true);
            this.write = write = BindingUtils.getInterfaceMethod(write);
            this.writer = new MethodWriter(this.write);
        }
        if (field != null) {
            field.setAccessible(true);
            this.field = field;
            if (read == null) {
                this.reader = new FieldReader(field);
            }
            if (write == null) {
                this.writer = new FieldWriter(field);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Field getField() {
        return this.field;
    }

    public Method getReadMethod() {
        return this.read;
    }

    public Method getWriteMethod() {
        return this.write;
    }

    public Method getInitMethod() {
        return this.init;
    }

    public void setInitMethod(Method method) {
        method.setAccessible(true);
        this.init = BindingUtils.getInterfaceMethod(method);
        if (this.field != null && this.reader != null) {
            this.reader = new InitReader(this.field, this.init, this.reader);
        }
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
    }

    public boolean isReadable() {
        return this.reader != null;
    }

    public boolean isWriteable() {
        return this.writer != null;
    }

    public boolean isReadOnly() {
        return this.writer == null;
    }

    public boolean isWriteOnly() {
        return this.reader == null;
    }

    public Object getModelValue(ModelBean bean) {
        if (this.reader != null) {
            try {
                return this.reader.get(bean);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        return null;
    }

    public void setModelValue(ModelBean bean, Object value) {
        if (this.writer != null) {
            try {
                this.writer.set(bean, TypeCoercion.coerce((Object)value, this.type));
            }
            catch (Exception ex) {
                throw new FacesException(Resources._T("MVB_PROPERTY_INJECTION_FAILED", bean.getNamesString(), this.name), (Throwable)ex);
            }
        }
    }

    private static class MethodWriter
    extends Writer {
        private final Method method;

        MethodWriter(Method method) {
            this.method = method;
        }

        void set(ModelBean bean, Object value) throws Exception {
            bean.invoke(this.method, value);
        }
    }

    private static class MethodReader
    extends Reader {
        private final Method method;

        MethodReader(Method method) {
            this.method = method;
        }

        Object get(ModelBean bean) throws Exception {
            return bean.invoke(this.method, new Object[0]);
        }
    }

    private class InitReader
    extends Reader {
        private final Field field;
        private final Method init;
        private final Reader reader;

        InitReader(Field field, Method init, Reader reader) {
            this.field = field;
            this.init = init;
            this.reader = reader;
        }

        Object get(ModelBean bean) throws Exception {
            Object value = bean.getField(this.field);
            if (value == null && (value = bean.invoke(this.init, new Object[0])) != null) {
                bean.setField(this.field, value);
            }
            return this.reader.get(bean);
        }
    }

    private static class FieldWriter
    extends Writer {
        private final Field field;

        FieldWriter(Field field) {
            this.field = field;
        }

        void set(ModelBean bean, Object value) throws Exception {
            bean.setField(this.field, value);
        }
    }

    private static class FieldReader
    extends Reader {
        private final Field field;

        FieldReader(Field field) {
            this.field = field;
        }

        Object get(ModelBean bean) throws Exception {
            return bean.getField(this.field);
        }
    }

    private static abstract class Writer {
        private Writer() {
        }

        abstract void set(ModelBean var1, Object var2) throws Exception;
    }

    private static abstract class Reader {
        private Reader() {
        }

        abstract Object get(ModelBean var1) throws Exception;
    }
}

