/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.PhaseId;
import javax.faces.validator.Validator;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.factories.CustomizingConverterFactory;
import org.operamasks.faces.binding.factories.CustomizingValidatorFactory;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.PropertyBinding;
import org.operamasks.faces.binding.impl.PropertyValueAdapter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParamBinding
extends PropertyBinding {
    private String id;
    private ConverterFactory converterFactory;
    private String converterMessage;
    private List<ValidatorFactory> validators;
    private boolean required;
    private String requiredMessage;

    public RequestParamBinding(String viewId) {
        super(viewId);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public String getConverterMessage() {
        return this.converterMessage;
    }

    public void setConverterMessage(String message) {
        this.converterMessage = message;
    }

    public void addValidatorFactory(ValidatorFactory factory) {
        if (this.validators == null) {
            this.validators = new ArrayList<ValidatorFactory>();
        }
        this.validators.add(factory);
    }

    public List<ValidatorFactory> getValidatorFactories() {
        if (this.validators == null) {
            return Collections.emptyList();
        }
        return this.validators;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(String message) {
        this.requiredMessage = message;
    }

    public void applyRequestValue(FacesContext ctx, UIComponent comp) {
        String requestValue = (String)ctx.getExternalContext().getRequestParameterMap().get(this.id);
        if (requestValue == null) {
            return;
        }
        ((EditableValueHolder)comp).setSubmittedValue((Object)requestValue);
        comp.processValidators(ctx);
        comp.processUpdates(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        if (mbc.getPhaseId() == PhaseId.RENDER_RESPONSE && !FacesUtils.isPostback(ctx)) {
            UIComponent adapter = this.createAdapter(ctx, mbc.getModelBean());
            ctx.getViewRoot().getChildren().add(adapter);
            try {
                this.applyRequestValue(ctx, adapter);
            }
            finally {
                ctx.getViewRoot().getChildren().remove(adapter);
            }
        }
    }

    private UIComponent createAdapter(FacesContext ctx, ModelBean bean) {
        UIInput adapter = new UIInput();
        adapter.setId(this.id);
        adapter.setValueExpression("value", (ValueExpression)new PropertyValueAdapter(this, bean));
        this.addConverter(ctx, adapter, bean);
        this.addValidators(adapter, bean);
        return adapter;
    }

    private void addConverter(FacesContext ctx, UIInput adapter, ModelBean bean) {
        ConverterFactory factory = this.converterFactory;
        Converter converter = null;
        if (factory != null) {
            converter = factory instanceof CustomizingConverterFactory ? ((CustomizingConverterFactory)factory).createConverter(bean, this.type) : factory.createConverter(this.type);
        } else if (this.type != String.class && this.type != Object.class) {
            converter = ctx.getApplication().createConverter(this.type);
        }
        if (converter != null) {
            adapter.setConverter(converter);
        }
        this.setText((UIComponent)adapter, bean, this.converterMessage, "converterMessage");
    }

    private void addValidators(UIInput adapter, ModelBean bean) {
        if (this.required) {
            adapter.setRequired(true);
            this.setText((UIComponent)adapter, bean, this.requiredMessage, "requiredMessage");
        }
        if (this.validators != null) {
            for (ValidatorFactory factory : this.validators) {
                Validator validator = factory instanceof CustomizingValidatorFactory ? ((CustomizingValidatorFactory)factory).createValidator(bean) : factory.createValidator();
                if (validator == null) continue;
                adapter.addValidator(validator);
            }
        }
        this.setText((UIComponent)adapter, bean, null, "validatorMessage");
    }

    private void setText(UIComponent comp, ModelBean bean, String text, String messageId) {
        if (text == null || text.length() == 0) {
            text = OMUtils.getLocalString(this.getDeclaringClass(), this.getName() + "." + messageId);
        }
        if (text != null) {
            ValueExpression ve = BindingUtils.createValueWrapper(bean, text, String.class);
            comp.setValueExpression(messageId, ve);
        }
    }
}

