/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.faces.context.FacesContext;
import org.operamasks.faces.application.ApplicationAssociate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeManager
implements Serializable {
    private static final long serialVersionUID = -2714748675781507975L;
    private static final String KEY = ScopeManager.class.getName();
    private final transient ConcurrentScopeMap applicationMap = new ConcurrentScopeMap();

    public static ScopeManager getInstance() {
        return ApplicationAssociate.getInstance().getSingleton(ScopeManager.class);
    }

    public Map<String, Object> getApplicationMap(FacesContext context, String viewId) {
        return this.applicationMap.get(viewId);
    }

    public Map<String, Object> getSessionMap(FacesContext context, String viewId) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        ConcurrentScopeMap scopeMap = (ConcurrentScopeMap)sessionMap.get(KEY);
        if (scopeMap == null) {
            scopeMap = new ConcurrentScopeMap();
            sessionMap.put(KEY, scopeMap);
        }
        return scopeMap.get(viewId);
    }

    public Map<String, Object> getRequestMap(FacesContext context, String viewId) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ScopeMap scopeMap = (ScopeMap)requestMap.get(KEY);
        if (scopeMap == null) {
            scopeMap = new ScopeMap();
            requestMap.put(KEY, scopeMap);
        }
        return scopeMap.get(viewId);
    }

    private ScopeManager() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConcurrentScopeMap {
        private ConcurrentMap<String, ConcurrentMap<String, Object>> scopeMap = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();

        private ConcurrentScopeMap() {
        }

        public ConcurrentMap<String, Object> get(String key) {
            ConcurrentMap old;
            ConcurrentMap scope = (ConcurrentHashMap)this.scopeMap.get(key);
            if (scope == null && (old = (ConcurrentMap)this.scopeMap.putIfAbsent(key, scope = new ConcurrentHashMap())) != null) {
                scope = old;
            }
            return scope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScopeMap {
        private Map<String, Map<String, Object>> scopeMap = new HashMap<String, Map<String, Object>>();

        private ScopeMap() {
        }

        public Map<String, Object> get(String key) {
            Map<String, Object> scope = this.scopeMap.get(key);
            if (scope == null) {
                scope = new HashMap<String, Object>();
                this.scopeMap.put(key, scope);
            }
            return scope;
        }
    }
}

