/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Method;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.validator.ClientValidator;
import org.operamasks.resources.Resources;

public class ValidatorAdapter
implements Validator,
ClientValidator,
StateHolder {
    private ModelBean bean;
    private Method method;
    private String script;
    private String message;

    public ValidatorAdapter(ModelBean bean, Method method, String script, String message) {
        this.bean = bean;
        this.method = method;
        this.script = script;
        this.message = message;
    }

    public ModelBean getModelBean() {
        return this.bean;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            this.bean.inject(context);
            Object result = null;
            try {
                Class<?>[] paramTypes = this.method.getParameterTypes();
                if (paramTypes.length == 1) {
                    value = this.coerce(value, paramTypes[0]);
                    result = this.bean.invoke(this.method, value);
                } else if (paramTypes.length == 3) {
                    value = this.coerce(value, paramTypes[2]);
                    result = this.bean.invoke(this.method, context, component, value);
                }
            }
            catch (ValidatorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String errInfo = ex.getMessage();
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errInfo, errInfo);
                throw new ValidatorException(message, ex.getCause());
            }
            if (result != null) {
                String messageStr;
                if (result instanceof String) {
                    messageStr = (String)result;
                    if (FacesUtils.isValueExpression(messageStr)) {
                        messageStr = this.bean.evaluateExpression(messageStr, String.class);
                    }
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                    throw new ValidatorException(message);
                }
                if (Boolean.FALSE.equals(result)) {
                    messageStr = this.message;
                    if (messageStr == null || messageStr.length() == 0) {
                        messageStr = (String)component.getAttributes().get("validatorMessage");
                    } else if (FacesUtils.isValueExpression(messageStr)) {
                        messageStr = this.bean.evaluateExpression(messageStr, String.class);
                    }
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                    throw new ValidatorException(message);
                }
            }
        }
    }

    private Object coerce(Object value, Class type) {
        if (value != null && type != value.getClass() || value == null && type.isPrimitive()) {
            value = TypeCoercion.coerce((Object)value, (Class)type);
        }
        return value;
    }

    public String getValidatorScript(FacesContext context, UIComponent component) {
        return null;
    }

    public String getValidatorInstanceScript(FacesContext context, UIComponent component) {
        if (this.script != null && this.script.length() != 0) {
            String display;
            String message = this.message;
            if (message == null || message.length() == 0) {
                message = (String)component.getAttributes().get("validatorMessage");
                if (message == null) {
                    message = Resources._T("JSF_CLIENT_VALIDATE_ERROR", FacesUtils.getLabel(context, component));
                }
            } else if (FacesUtils.isValueExpression(message)) {
                message = this.bean.evaluateExpression(message, String.class);
            }
            if ((display = FacesUtils.getMessageComponentId(context, component)) != null) {
                display = HtmlEncoder.enquote(display);
            }
            return "new ClientValidator('" + component.getClientId(context) + "'," + HtmlEncoder.enquote(message) + "," + display + "," + "function(value){" + this.script + "}" + ")";
        }
        return null;
    }

    public Object saveState(FacesContext context) {
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
    }

    public boolean isTransient() {
        return true;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

