/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.CompositeValidator;
import org.operamasks.faces.binding.impl.EmptyValueValidatorAdapter;
import org.operamasks.faces.binding.impl.ValidatorAdapter;

public final class ValidatorBinding
extends Binding {
    private String[] ids;
    private Method method;
    private String script;
    private String message;
    private boolean ignoreEmpty;

    public ValidatorBinding(String viewId, String[] ids) {
        super(viewId);
        this.ids = ids;
    }

    public String[] getIds() {
        return this.ids;
    }

    public Method getValidateMethod() {
        return this.method;
    }

    public void setValidateMethod(Method method) {
        method.setAccessible(true);
        this.method = BindingUtils.getInterfaceMethod(method);
    }

    public String getValidateScript() {
        return this.script;
    }

    public void setValidateScript(String script) {
        this.script = script;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public void apply(FacesContext ctx, ModelBindingContext mbc) {
        ModelBean bean = mbc.getModelBean();
        for (String id : this.ids) {
            UIComponent comp = mbc.getComponent(id);
            if (comp == null || !(comp instanceof EditableValueHolder)) continue;
            CompositeValidator composite = CompositeValidator.getCompositeValidator((EditableValueHolder)comp, mbc.getPhaseId(), this.ignoreEmpty);
            composite.addValidator(this.createValidatorAdapter(bean));
        }
    }

    private ValidatorAdapter createValidatorAdapter(ModelBean bean) {
        if (this.ignoreEmpty) {
            return new ValidatorAdapter(bean, this.method, this.script, this.message);
        }
        return new EmptyValueValidatorAdapter(bean, this.method, this.script, this.message);
    }

    public void applyDataItem(FacesContext ctx, ModelBindingContext mbc, UIData data) {
        if (!Modifier.isStatic(this.method.getModifiers())) {
            return;
        }
        for (String id : this.ids) {
            UIComponent comp = mbc.getComponent(id);
            if (comp == null || !(comp instanceof EditableValueHolder)) continue;
            CompositeValidator composite = CompositeValidator.getCompositeValidator((EditableValueHolder)comp, mbc.getPhaseId(), this.ignoreEmpty);
            ModelBean bean = ModelBean.NULL_MODEL_BEAN;
            composite.addValidator(this.createValidatorAdapter(bean));
        }
    }
}

