/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl.processor.elbean;

import elite.lang.Annotation;
import elite.lang.Closure;
import javax.el.ELContext;
import javax.faces.component.UIComponent;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.ELSelectItemsBinding;
import org.operamasks.faces.binding.impl.ELValueBinding;
import org.operamasks.faces.binding.impl.processor.elbean.AnnotationProcessor;
import org.operamasks.faces.binding.impl.processor.elbean.ProcessorUtils;

public class BindProcessor
extends AnnotationProcessor {
    public BindProcessor() {
        super("Bind");
    }

    protected Binding build(ELContext ctx, String name, Closure c, Annotation meta) {
        Class<Object> type = c.getType(ctx);
        String id = (String)meta.getAttribute("id", String.class);
        String attribute = (String)meta.getAttribute("attribute", String.class);
        if (type == null) {
            type = Object.class;
        }
        if (id == null) {
            id = name;
        }
        if (attribute == null) {
            attribute = UIComponent.class.isAssignableFrom(type) ? "binding" : "value";
        }
        ELValueBinding b = new ELValueBinding(c, type, id, attribute);
        b.setOrder((Integer)meta.getAttribute("order", Integer.TYPE));
        this.scanConverterAndValidators(ctx, b, c);
        this.scanSelectItems(b, name, c);
        return b;
    }

    private void scanConverterAndValidators(ELContext ctx, ELValueBinding b, Closure c) {
        for (Annotation a : c.getAnnotations()) {
            ValidatorFactory vf;
            ConverterFactory cf = ProcessorUtils.createConverterFactory(ctx, a);
            if (cf != null) {
                b.setConverterFactory(cf);
                b.setConverterMessage((String)a.getAttribute("message", String.class));
            }
            if ((vf = ProcessorUtils.createValidatorFactory(ctx, a)) == null) continue;
            b.addValidatorFactory(vf);
        }
        Annotation required = c.getAnnotation("Required");
        if (required != null) {
            b.setRequired(true);
            b.setRequiredMessage((String)required.getAttribute("message", String.class));
        }
    }

    private void scanSelectItems(ELValueBinding b, String name, Closure c) {
        Annotation meta = c.getAnnotation("SelectItems");
        if (meta != null) {
            ELSelectItemsBinding sel = new ELSelectItemsBinding(c, name, b.getType());
            ProcessorUtils.scanSelectItems(sel, meta);
            b.setSelectItems(sel);
        }
    }
}

