/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.misc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.HiddenStateStub;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;

public class UIHiddenState
extends UIComponentBase
implements HiddenStateStub {
    private static final String HIDDEN_FIELDS_ATTR = "org.operamasks.faces.HIDDEN_FIElDS";
    private PhaseId phaseId;
    private Map<String, ValueExpression> states = new HashMap<String, ValueExpression>();

    public UIHiddenState() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return null;
    }

    public PhaseId getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(PhaseId phaseId) {
        this.phaseId = phaseId;
    }

    public void addAttachedState(String name, ValueExpression binding) {
        this.states.put(name, binding);
    }

    public void clearAttachedStates() {
        this.states.clear();
    }

    public void decode(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        for (String name : this.states.keySet()) {
            String param = (String)paramMap.get(name);
            if (param == null) continue;
            ValueExpression binding = this.states.get(name);
            Object value = this.getConvertedValue(context, binding, param);
            binding.setValue(context.getELContext(), value);
        }
    }

    public void encodeAll(FacesContext context) {
        if (this.phaseId != PhaseId.RENDER_RESPONSE) {
            return;
        }
        if (this.states.size() > 0) {
            ResponseWriter out = context.getResponseWriter();
            if (out instanceof AjaxResponseWriter) {
                this.encodeAjaxValues(context, (AjaxResponseWriter)out);
            } else if (out instanceof AjaxHtmlResponseWriter) {
                this.encodeAjaxHtmlValues(context, (AjaxHtmlResponseWriter)out);
            } else {
                this.attachStateInForms(context);
            }
        }
    }

    private void encodeAjaxValues(FacesContext context, AjaxResponseWriter out) {
        for (String name : this.states.keySet()) {
            ValueExpression binding = this.states.get(name);
            String value = this.getFormattedValue(context, binding);
            out.addRequestParameter(name, value);
        }
    }

    private void encodeAjaxHtmlValues(FacesContext context, AjaxHtmlResponseWriter out) {
        for (String name : this.states.keySet()) {
            ValueExpression binding = this.states.get(name);
            String value = this.getFormattedValue(context, binding);
            out.addRequestParameter(name, value);
        }
    }

    private void attachStateInForms(FacesContext context) {
        Iterator<UIComponent> kids = FacesUtils.createChildrenIterator((UIComponent)context.getViewRoot(), false);
        while (kids.hasNext()) {
            UIComponent comp = kids.next();
            if (!(comp instanceof UIForm) || !comp.isRendered()) continue;
            this.addHiddenFields(context, (UIForm)comp);
        }
    }

    private void addHiddenFields(FacesContext context, UIForm form) {
        for (String name : this.states.keySet()) {
            ValueExpression binding = this.states.get(name);
            String value = this.getFormattedValue(context, binding);
            this.addHiddenFields(form, name, value);
        }
    }

    private void addHiddenFields(UIForm form, String name, String value) {
        String key;
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap<String, String> hiddenFields = (HashMap<String, String>)requestMap.get(key = HIDDEN_FIELDS_ATTR + form.getClientId(context));
        if (hiddenFields == null) {
            hiddenFields = new HashMap<String, String>();
            requestMap.put(key, hiddenFields);
        }
        hiddenFields.put(name, value);
    }

    private Object getConvertedValue(FacesContext context, ValueExpression binding, String value) {
        Class type = binding.getType(context.getELContext());
        return TypeCoercion.coerce((Object)value, (Class)type);
    }

    private String getFormattedValue(FacesContext context, ValueExpression binding) {
        Object value = binding.getValue(context.getELContext());
        return value == null ? null : value.toString();
    }
}

