/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.config;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import org.operamasks.faces.annotation.DefineConverter;
import org.operamasks.faces.annotation.DefineValidator;
import org.operamasks.faces.annotation.EventListener;
import org.operamasks.faces.annotation.Factory;
import org.operamasks.faces.annotation.ListEntries;
import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedProperty;
import org.operamasks.faces.annotation.MapEntries;
import org.operamasks.faces.annotation.MapEntry;
import org.operamasks.faces.annotation.PhaseListener;
import org.operamasks.faces.config.ConverterConfig;
import org.operamasks.faces.config.ManagedBeanConfig;
import org.operamasks.faces.config.ValidatorConfig;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessor {
    private static final String BASE_PATH = "/WEB-INF/classes/";
    private ServletContext context;
    private ClassLoader loader;
    private List<ManagedBeanConfig> managedBeans;
    private List<ConverterConfig> converters;
    private List<ValidatorConfig> validators;
    private List<String> metaDataJars;
    private List<String> metaDataDirs;
    private List<String> metaDataPackages;
    private List<String> phaseListeners;
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.config");

    public AnnotationProcessor(ServletContext context, ClassLoader loader) {
        this.context = context;
        this.loader = loader;
        this.managedBeans = new ArrayList<ManagedBeanConfig>();
        this.converters = new ArrayList<ConverterConfig>();
        this.validators = new ArrayList<ValidatorConfig>();
        this.phaseListeners = new ArrayList<String>();
    }

    public void scan() {
        this.scan(BASE_PATH);
        this.scanMetadata();
    }

    private void scanMetadata() {
        try {
            File metadataBaseDir;
            String metadataBasePath;
            String libDirPath;
            File libDir;
            if (this.metaDataJars != null && this.metaDataJars.size() != 0 && (libDir = new File(libDirPath = this.context.getRealPath("/WEB-INF/lib"))).exists() && libDir.isDirectory()) {
                File[] libs;
                for (File lib : libs = libDir.listFiles()) {
                    if (!lib.isFile() || !lib.getName().endsWith(".jar") || !this.isMetaDataJar(lib.getName())) continue;
                    try {
                        JarFile jar = new JarFile(lib);
                        this.scan(jar);
                    }
                    catch (IOException e) {
                        throw new FacesException("Illegal jar file: " + lib.getName());
                    }
                }
            }
            if (this.metaDataJars != null && this.metaDataJars.size() != 0) {
                for (String jarPath : this.metaDataJars) {
                    if (!jarPath.endsWith(".jar")) continue;
                    if (this.isAbsolutePath(jarPath = jarPath.replace('/', File.separatorChar).replace('\\', File.separatorChar))) {
                        JarFile jar = new JarFile(jarPath);
                        this.scan(jar);
                        continue;
                    }
                    metadataBasePath = this.context.getRealPath("/WEB-INF");
                    metadataBaseDir = new File(metadataBasePath);
                    File f = new File(metadataBaseDir, jarPath);
                    if (!f.exists()) continue;
                    JarFile jar = new JarFile(f);
                    this.scan(jar);
                }
            }
            if (this.metaDataDirs != null && this.metaDataDirs.size() != 0) {
                for (String dirPath : this.metaDataDirs) {
                    if (this.isAbsolutePath(dirPath = dirPath.replace('/', File.separatorChar).replace('\\', File.separatorChar))) {
                        this.scanDir(new File(dirPath), "");
                        continue;
                    }
                    metadataBasePath = this.context.getRealPath("/WEB-INF");
                    metadataBaseDir = new File(metadataBasePath);
                    File d = new File(metadataBaseDir, dirPath);
                    if (!d.exists()) continue;
                    this.scanDir(d, "");
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException("Failed to scan metadata", e);
        }
    }

    private boolean isAbsolutePath(String path) {
        if (path.startsWith(File.separator)) {
            return true;
        }
        if (path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            return true;
        }
        return path.indexOf(":") > -1;
    }

    private boolean isMetaDataJar(String jarName) {
        for (String metaDataJar : this.metaDataJars) {
            if (!metaDataJar.equals(jarName)) continue;
            return true;
        }
        return false;
    }

    private void scanDir(File omPath, String base) {
        File[] files;
        for (File file : files = omPath.listFiles()) {
            String className;
            String fileName = base + File.separator + file.getName();
            if (file.isDirectory()) {
                this.scanDir(file, fileName);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            if (fileName.startsWith(File.separator)) {
                fileName = fileName.substring(File.separator.length());
            }
            if (!this.isInMetaDataPackages(className = fileName.replace(File.separatorChar, '.').substring(0, fileName.length() - 6))) continue;
            try {
                this.scanClass(this.loader.loadClass(className));
            }
            catch (NoClassDefFoundError e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    private void scan(JarFile jar) {
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            String className;
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !(className = jarEntry.getName()).endsWith(".class")) continue;
            if ((className = className.substring(0, className.length() - 6)).startsWith("/")) {
                className = className.substring(1);
            }
            if (!this.isInMetaDataPackages(className = className.replace('/', '.'))) continue;
            try {
                this.scanClass(this.loader.loadClass(className));
            }
            catch (NoClassDefFoundError e) {
            }
            catch (ClassNotFoundException e) {}
        }
    }

    private boolean isInMetaDataPackages(String name) {
        for (String metaDataPackage : this.metaDataPackages) {
            int length;
            if (metaDataPackage.equals("*")) {
                return true;
            }
            if (metaDataPackage.endsWith("*") && (length = metaDataPackage.length()) > 1) {
                metaDataPackage = metaDataPackage.substring(0, length - 1);
            }
            if (!name.startsWith(metaDataPackage)) continue;
            return true;
        }
        return false;
    }

    public List<ManagedBeanConfig> getManagedBeans() {
        return this.managedBeans;
    }

    public List<ConverterConfig> getConverters() {
        return this.converters;
    }

    public List<ValidatorConfig> getValidators() {
        return this.validators;
    }

    private void scan(String path) {
        Set paths = this.context.getResourcePaths(path);
        if (paths != null) {
            for (String file : paths) {
                if (file.endsWith("/")) {
                    this.scan(file);
                    continue;
                }
                if (!file.endsWith(".class")) continue;
                try {
                    String classname = file.substring(BASE_PATH.length(), file.length() - 6);
                    classname = classname.replace('/', '.');
                    this.scanClass(this.loader.loadClass(classname));
                }
                catch (ClassNotFoundException ex) {
                }
                catch (NoClassDefFoundError ex) {}
            }
        }
    }

    public void scanClass(Class<?> clazz) {
        ValidatorConfig validator;
        ConverterConfig converter;
        ManagedBeanConfig mbean = this.scanManagedBeanClass(clazz);
        if (mbean != null) {
            this.managedBeans.add(mbean);
        }
        if ((converter = this.scanConverterClass(clazz)) != null) {
            this.converters.add(converter);
        }
        if ((validator = this.scanValidatorClass(clazz)) != null) {
            this.validators.add(validator);
        }
        if (clazz.getAnnotation(PhaseListener.class) != null) {
            this.phaseListeners.add(clazz.getName());
        }
    }

    public ManagedBeanConfig scanManagedBeanClass(Class<?> clazz) {
        ManagedBean meta = clazz.getAnnotation(ManagedBean.class);
        if (meta == null) {
            return null;
        }
        String classname = clazz.getName();
        String beanName = meta.name();
        if (beanName.length() == 0) {
            beanName = classname.substring(classname.lastIndexOf(46) + 1);
        }
        ManagedBeanConfig mbean = new ManagedBeanConfig();
        mbean.setManagedBeanName(beanName);
        mbean.setManagedBeanClass(classname);
        mbean.setManagedBeanScope(meta.scope());
        mbean.setDisplayName(meta.displayName());
        mbean.setDescription(meta.description());
        this.scanProperties(mbean, clazz);
        this.scanEventListeners(mbean, clazz);
        this.scanFactoryMethods(mbean, clazz);
        return mbean;
    }

    public void scanManagedBean(ManagedBeanConfig mbean) {
        Class<?> clazz;
        try {
            clazz = this.loader.loadClass(mbean.getManagedBeanClass());
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.WARNING, mbean.getManagedBeanClass() + " could not be found: " + ex);
            return;
        }
        catch (NoClassDefFoundError ex) {
            this.logger.log(Level.WARNING, "no definition of " + mbean.getManagedBeanClass() + " could be found: " + ex);
            return;
        }
        this.scanProperties(mbean, clazz);
        this.scanEventListeners(mbean, clazz);
        this.scanFactoryMethods(mbean, clazz);
    }

    private void scanProperties(ManagedBeanConfig mbean, Class<?> clazz) {
        Collection properties;
        try {
            properties = BeanUtils.getProperties(clazz);
        }
        catch (IntrospectionException ex) {
            throw new FacesException((Throwable)ex);
        }
        for (BeanProperty p : properties) {
            String name = p.getName();
            Class type = p.getType();
            Method readMethod = p.getReadMethod();
            Method writeMethod = p.getWriteMethod();
            if (readMethod != null) {
                this.scanProperty(mbean, readMethod, name, type);
                continue;
            }
            if (writeMethod == null) continue;
            this.scanProperty(mbean, writeMethod, name, type);
        }
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                ManagedBeanConfig.Property p;
                String name = field.getName();
                Class<?> type = field.getType();
                if (mbean.getManagedProperty(name) != null || (p = this.scanProperty(mbean, field, name, type)) == null) continue;
                field.setAccessible(true);
                p.setField(field);
            }
        }
    }

    private ManagedBeanConfig.Property scanProperty(ManagedBeanConfig bean, AccessibleObject member, String name, Class type) {
        ManagedBeanConfig.Property p = null;
        if (member.isAnnotationPresent(ManagedProperty.class)) {
            ManagedProperty meta = member.getAnnotation(ManagedProperty.class);
            String value = meta.value();
            if (value != null && value.length() != 0) {
                p = new ManagedBeanConfig.Property(name, type.getName());
                p.setValue(value);
                bean.addManagedProperty(p);
            }
        } else if (member.isAnnotationPresent(MapEntries.class)) {
            MapEntries meta = member.getAnnotation(MapEntries.class);
            ManagedBeanConfig.MapEntries entries = new ManagedBeanConfig.MapEntries();
            entries.setKeyClass(meta.keyClass().getName());
            entries.setValueClass(meta.valueClass().getName());
            for (MapEntry entry : meta.value()) {
                entries.addMapEntry(entry.key(), entry.value());
            }
            p = new ManagedBeanConfig.Property(name, type.getName());
            p.setMapEntries(entries);
            bean.addManagedProperty(p);
        } else if (member.isAnnotationPresent(ListEntries.class)) {
            ListEntries meta = member.getAnnotation(ListEntries.class);
            ManagedBeanConfig.ListEntries entries = new ManagedBeanConfig.ListEntries();
            if (type.isArray()) {
                entries.setValueClass(type.getComponentType().getName());
            } else {
                entries.setValueClass(meta.valueClass().getName());
            }
            for (String entry : meta.value()) {
                entries.addValue(entry);
            }
            p = new ManagedBeanConfig.Property(name, type.getName());
            p.setListEntries(entries);
            bean.addManagedProperty(p);
        }
        return p;
    }

    private void scanEventListeners(ManagedBeanConfig mbean, Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                EventListener meta = method.getAnnotation(EventListener.class);
                if (meta == null) continue;
                String[] eventTypes = meta.value();
                if (eventTypes.length == 0) {
                    eventTypes = new String[]{method.getName()};
                }
                method.setAccessible(true);
                ManagedBeanConfig.EventListener listener = new ManagedBeanConfig.EventListener();
                listener.setEventTypes(eventTypes);
                listener.setListenerMethod(method);
                mbean.addEventListener(listener);
            }
        }
    }

    private void scanFactoryMethods(ManagedBeanConfig mbean, Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                Factory meta = method.getAnnotation(Factory.class);
                if (meta == null) continue;
                this.addFactoryMethod(mbean, method, meta);
            }
        }
    }

    private void addFactoryMethod(ManagedBeanConfig mbean, Method method, Factory meta) {
        Class<?> type = method.getReturnType();
        if (type == Void.TYPE) {
            throw new FacesException("The factory method '" + method.getName() + "' must hava a return value.");
        }
        String typename = type.getName();
        String name = meta.name();
        if (name == null || name.length() == 0) {
            name = typename.substring(typename.lastIndexOf(46) + 1);
        }
        for (ManagedBeanConfig.FactoryMethod fm : mbean.getFactoryMethods()) {
            if (!name.equals(fm.getManagedBeanName())) continue;
            throw new FacesException("Duplciate factory method name: " + name);
        }
        ManagedBeanConfig.FactoryMethod factory = new ManagedBeanConfig.FactoryMethod();
        factory.setFactoryName(mbean.getManagedBeanName());
        factory.setManagedBeanName(name);
        factory.setManagedBeanClass(typename);
        factory.setManagedBeanScope(meta.scope());
        this.scanProperties(factory, type);
        this.scanEventListeners(factory, type);
        this.scanFactoryMethods(factory, type);
        method.setAccessible(true);
        factory.setMethod(method);
        mbean.addFactoryMethod(factory);
    }

    public ConverterConfig scanConverterClass(Class<?> clazz) {
        DefineConverter meta = clazz.getAnnotation(DefineConverter.class);
        if (meta == null) {
            return null;
        }
        String id = meta.id();
        Class<?> type = meta.forType();
        if (id.length() == 0 && type == Object.class) {
            id = clazz.getName();
        }
        ConverterConfig converter = new ConverterConfig();
        if (id.length() != 0) {
            converter.setConverterId(id);
        }
        if (type != Object.class) {
            converter.setConverterForClass(type.getName());
        }
        converter.setConverterClass(clazz.getName());
        return converter;
    }

    public ValidatorConfig scanValidatorClass(Class<?> clazz) {
        DefineValidator meta = clazz.getAnnotation(DefineValidator.class);
        if (meta == null) {
            return null;
        }
        String id = meta.id();
        if (id.length() == 0) {
            id = clazz.getName();
        }
        ValidatorConfig validator = new ValidatorConfig();
        validator.setValidatorId(id);
        validator.setValidatorClass(clazz.getName());
        return validator;
    }

    public List<String> getMetaDataJars() {
        return this.metaDataJars;
    }

    public void setMetaDataJars(List<String> metadataJars) {
        this.metaDataJars = metadataJars;
    }

    public void setMetaDataDirs(List<String> metaDataDirs) {
        this.metaDataDirs = metaDataDirs;
    }

    public List<String> getMetaDataDirs() {
        return this.metaDataDirs;
    }

    public List<String> getMetaDataPackages() {
        return this.metaDataPackages;
    }

    public void setMetaDataPackages(List<String> metadataPackages) {
        this.metaDataPackages = metadataPackages;
    }

    public List<String> getPhaseListeners() {
        return this.phaseListeners;
    }
}

