/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletExternalContext
extends ExternalContext {
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ScopeManager scope;

    ServletExternalContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.scope = new ScopeManager();
    }

    public void dispatch(String path) throws IOException {
        try {
            RequestDispatcher dispatcher = this.context.getRequestDispatcher(path);
            dispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public void redirect(String url) throws IOException {
        this.response.sendRedirect(url);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public String encodeActionURL(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeNamespace(String name) {
        return name;
    }

    public String encodeResourceURL(String url) {
        return this.response.encodeURL(url);
    }

    public Map<String, Object> getApplicationMap() {
        return this.scope.getApplicationMap(this.context);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Object getContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Map<String, String> getInitParameterMap() {
        return this.scope.getInitParameterMap(this.context);
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        if (request == null) {
            throw new NullPointerException();
        }
        if (request instanceof HttpServletRequest) {
            this.request = (HttpServletRequest)request;
        }
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(encoding);
    }

    public String getRequestContextPath() {
        return this.request.getContextPath();
    }

    public Map<String, Object> getRequestCookieMap() {
        return this.scope.getCookieMap(this.request);
    }

    public Map<String, String> getRequestHeaderMap() {
        return this.scope.getHeaderMap(this.request);
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        return this.scope.getHeaderValuesMap(this.request);
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        final Enumeration enu = this.request.getLocales();
        return new Iterator<Locale>(){

            @Override
            public boolean hasNext() {
                return enu.hasMoreElements();
            }

            @Override
            public Locale next() {
                return (Locale)enu.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<String, Object> getRequestMap() {
        return this.scope.getRequestMap(this.request);
    }

    public Map<String, String> getRequestParameterMap() {
        return this.scope.getParameterMap(this.request);
    }

    public Iterator<String> getRequestParameterNames() {
        final Enumeration enu = this.request.getParameterNames();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return enu.hasMoreElements();
            }

            @Override
            public String next() {
                return (String)enu.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        return this.scope.getParameterValuesMap(this.request);
    }

    public String getRequestPathInfo() {
        return this.request.getPathInfo();
    }

    public String getRequestServletPath() {
        return this.request.getServletPath();
    }

    public String getRequestCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getRequestContentType() {
        return this.request.getContentType();
    }

    public String getResponseCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public String getResponseContentType() {
        return this.response.getContentType();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object response) {
        if (response == null) {
            throw new NullPointerException();
        }
        this.response = (HttpServletResponse)response;
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.response.setCharacterEncoding(encoding);
    }

    public Object getSession(boolean create) {
        return this.request.getSession(create);
    }

    public Map<String, Object> getSessionMap() {
        return this.scope.getSessionMap(this.request);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(String message, Throwable exception) {
        this.context.log(message, exception);
    }

    private static abstract class ScopeMap
    extends AbstractMap {
        private ScopeMap() {
        }

        protected abstract Enumeration getAttributeNames();

        protected abstract Object getAttribute(String var1);

        protected void removeAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        protected void setAttribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public final Set entrySet() {
            Enumeration e = this.getAttributeNames();
            HashSet<ScopeEntry> result = new HashSet<ScopeEntry>();
            if (e != null) {
                while (e.hasMoreElements()) {
                    result.add(new ScopeEntry((String)e.nextElement()));
                }
            }
            return result;
        }

        public final Object get(Object key) {
            if (key != null) {
                return this.getAttribute(key.toString());
            }
            return null;
        }

        public final boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        public final Object put(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                this.removeAttribute(key.toString());
            } else {
                this.setAttribute(key.toString(), value);
            }
            return null;
        }

        public final Object remove(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.removeAttribute(key.toString());
            return null;
        }

        private class ScopeEntry
        implements Map.Entry {
            private final String key;

            public ScopeEntry(String key) {
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return ScopeMap.this.getAttribute(this.key);
            }

            public Object setValue(Object value) {
                if (value == null) {
                    ScopeMap.this.removeAttribute(this.key);
                } else {
                    ScopeMap.this.setAttribute(this.key, value);
                }
                return null;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                return this.hashCode() == obj.hashCode();
            }

            public int hashCode() {
                return this.key.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScopeManager {
        private Map<String, Object> applicationMap;
        private Map<String, String> initParamMap;
        private Map<String, Object> cookieMap;
        private Map<String, String> headerMap;
        private Map<String, String[]> headerValuesMap;
        private Map<String, String> paramMap;
        private Map<String, String[]> paramValuesMap;
        private Map<String, Object> requestMap;
        private Map<String, Object> sessionMap;

        private ScopeManager() {
        }

        public Map<String, Object> getApplicationMap(final ServletContext context) {
            if (this.applicationMap == null) {
                this.applicationMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return context.getAttributeNames();
                    }

                    protected Object getAttribute(String name) {
                        return context.getAttribute(name);
                    }

                    protected void setAttribute(String name, Object value) {
                        context.setAttribute(name, value);
                    }

                    protected void removeAttribute(String name) {
                        context.removeAttribute(name);
                    }
                };
            }
            return this.applicationMap;
        }

        public Map<String, Object> getCookieMap(HttpServletRequest request) {
            if (this.cookieMap == null) {
                this.cookieMap = new HashMap<String, Object>();
                if (request.getCookies() != null) {
                    for (Cookie c : request.getCookies()) {
                        if (this.cookieMap.containsKey(c.getName())) continue;
                        this.cookieMap.put(c.getName(), c);
                    }
                }
                this.cookieMap = Collections.unmodifiableMap(this.cookieMap);
            }
            return this.cookieMap;
        }

        public Map<String, String> getInitParameterMap(final ServletContext context) {
            if (this.initParamMap == null) {
                this.initParamMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return context.getInitParameterNames();
                    }

                    protected Object getAttribute(String name) {
                        return context.getInitParameter(name);
                    }
                };
            }
            return this.initParamMap;
        }

        public Map<String, String> getHeaderMap(final HttpServletRequest request) {
            if (this.headerMap == null) {
                this.headerMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return request.getHeaderNames();
                    }

                    protected Object getAttribute(String name) {
                        return request.getHeader(name);
                    }
                };
            }
            return this.headerMap;
        }

        public Map<String, String[]> getHeaderValuesMap(final HttpServletRequest request) {
            if (this.headerValuesMap == null) {
                this.headerValuesMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return request.getHeaderNames();
                    }

                    protected Object getAttribute(String name) {
                        Enumeration e = request.getHeaders(name);
                        if (e != null) {
                            ArrayList list = new ArrayList();
                            while (e.hasMoreElements()) {
                                list.add(e.nextElement());
                            }
                            return list.toArray(new String[list.size()]);
                        }
                        return null;
                    }
                };
            }
            return this.headerValuesMap;
        }

        public Map<String, String> getParameterMap(final HttpServletRequest request) {
            if (this.paramMap == null) {
                this.paramMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return request.getParameterNames();
                    }

                    protected Object getAttribute(String name) {
                        return request.getParameter(name);
                    }
                };
            }
            return this.paramMap;
        }

        public Map<String, String[]> getParameterValuesMap(final HttpServletRequest request) {
            if (this.paramValuesMap == null) {
                this.paramValuesMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return request.getParameterNames();
                    }

                    protected Object getAttribute(String name) {
                        return request.getParameterValues(name);
                    }
                };
            }
            return this.paramValuesMap;
        }

        public Map<String, Object> getRequestMap(final HttpServletRequest request) {
            if (this.requestMap == null) {
                this.requestMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return request.getAttributeNames();
                    }

                    protected Object getAttribute(String name) {
                        return request.getAttribute(name);
                    }

                    protected void setAttribute(String name, Object value) {
                        request.setAttribute(name, value);
                    }

                    protected void removeAttribute(String name) {
                        request.removeAttribute(name);
                    }
                };
            }
            return this.requestMap;
        }

        public Map<String, Object> getSessionMap(final HttpServletRequest request) {
            if (this.sessionMap == null) {
                this.sessionMap = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            return session.getAttributeNames();
                        }
                        return null;
                    }

                    protected Object getAttribute(String name) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            return session.getAttribute(name);
                        }
                        return null;
                    }

                    protected void setAttribute(String name, Object value) {
                        request.getSession().setAttribute(name, value);
                    }

                    protected void removeAttribute(String name) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            session.removeAttribute(name);
                        }
                    }
                };
            }
            return this.sessionMap;
        }
    }
}

