/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.developer.ajax;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.ajax.FormUpdatable;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateRenderer;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxUpdateMarker;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.user.ajax.UpdateLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialUpdateCandidates {
    private static final String UPDATE_CANDIDATES_KEY = "org.operamasks.update.candidates";
    private AjaxUpdateMarker marker = PartialUpdateManager.getInstance().getMarker();
    private Set<UIComponent> submitForms = new HashSet<UIComponent>();
    private static final String[] attributes = new String[]{"disabled", "readOnly"};

    private PartialUpdateCandidates() {
    }

    public static PartialUpdateCandidates getInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqMap = context.getExternalContext().getRequestMap();
        PartialUpdateCandidates pc = (PartialUpdateCandidates)reqMap.get(UPDATE_CANDIDATES_KEY);
        if (pc == null) {
            pc = new PartialUpdateCandidates();
            reqMap.put(UPDATE_CANDIDATES_KEY, pc);
        }
        return pc;
    }

    public void markSubmitForm(UIComponent form) {
        this.submitForms.add(form);
        String levelStr = (String)form.getAttributes().get("updateLevel");
        UpdateLevel level = UpdateLevel.Data;
        if (levelStr != null) {
            if (levelStr.equalsIgnoreCase("Specified")) {
                return;
            }
            level = PartialUpdateCandidates.decodeLevel(levelStr);
        }
        Iterator<UIComponent> it = FacesUtils.createChildrenIterator(form, true);
        while (it.hasNext()) {
            UIComponent kid = it.next();
            if (!(kid instanceof UIOutput) && !(kid instanceof FormUpdatable)) continue;
            this.marker.markUpdate(true, level, kid);
        }
    }

    public boolean isRepaintNeeded(UIComponent component) {
        if (!this.marker.isOrganized()) {
            throw new IllegalStateException("Marker data must be organized before invoking this method");
        }
        if (this.marker.isSkipped(component)) {
            return false;
        }
        return this.marker.isLevelMatch(component, UpdateLevel.ForceRepain);
    }

    public boolean isSkipped(UIComponent component) {
        return this.marker.isSkipped(component);
    }

    public Set<String> getAttributeCandidates(UIComponent component) {
        PartialUpdateRenderer renderer;
        if (!this.marker.isOrganized()) {
            throw new IllegalStateException("Marker data must be organized before invoking this method");
        }
        HashSet<String> candidates = new HashSet<String>();
        UpdateLevel level = this.marker.getUpdateLevel(component);
        if (level != UpdateLevel.Skip && level != UpdateLevel.ForceRepain) {
            this.addDynamicAttributes(component, candidates, this.marker.getSpecifiedAttributes(component));
            this.addLiteAttributes(component, candidates, level);
        }
        if ((renderer = AjaxUpdateMarker.getParticialRenderer(component)) != null) {
            Map<String, LiteAttributeEncoder> m = AjaxUpdateMarker.getParticialRenderer(component).getLiteAttributes();
            if (m != null) {
                Set<Map.Entry<String, LiteAttributeEncoder>> entries = m.entrySet();
                for (Map.Entry<String, LiteAttributeEncoder> entry : entries) {
                    int i = 0;
                    while (i < attributes.length) {
                        if (attributes[i].equals(entry.getKey())) {
                            candidates.add(entry.getKey().toString());
                        }
                        ++i;
                    }
                }
            }
            candidates.removeAll(AjaxUpdateMarker.getParticialRenderer(component).getUnupdatableAttributes());
        }
        return candidates;
    }

    private void addDynamicAttributes(UIComponent component, Set<String> candidates, Set<String> source) {
        for (String attr : source) {
            candidates.add(attr);
        }
    }

    public boolean isUpdateValue(UIComponent component) {
        return this.marker.isUpdateValue(component);
    }

    public boolean isUpdateDataModel(UIComponent component) {
        return this.marker.isUpdateDataModel(component);
    }

    private void addLiteAttributes(UIComponent component, Set<String> candidates, UpdateLevel level) {
        PartialUpdateRenderer renderer;
        if (level == UpdateLevel.Lite && (renderer = AjaxUpdateMarker.getParticialRenderer(component)) != null) {
            this.addDynamicAttributes(component, candidates, renderer.getLiteAttributes().keySet());
        }
    }

    public static void addLinkedUpdate(UIComponent component) {
        if (component == null) {
            return;
        }
        PartialUpdateCandidates instance = PartialUpdateCandidates.getInstance();
        for (UIComponent kid : component.getChildren()) {
            String exclude;
            if (!"org.operamasks.faces.ajax.AjaxLinkedUpdate".equals(kid.getFamily())) continue;
            Map attrMap = kid.getAttributes();
            UpdateLevel level = PartialUpdateCandidates.decodeLevel((String)attrMap.get("level"));
            String target = (String)attrMap.get("target");
            String attribute = (String)attrMap.get("attribute");
            boolean recursive = Boolean.TRUE.equals(attrMap.get("includeChildren"));
            if (target != null) {
                String[] targets = target.split(",");
                int i = 0;
                while (i < targets.length) {
                    targets[i] = targets[i].trim();
                    ++i;
                }
                if (attribute == null) {
                    instance.marker.markUpdate(recursive, level, targets);
                } else {
                    String[] attributes = attribute.split(",");
                    int i2 = 0;
                    while (i2 < targets.length) {
                        attributes[i2] = attributes[i2].trim();
                        ++i2;
                    }
                    String[] stringArray = targets;
                    int n = targets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t = stringArray[n2];
                        instance.marker.markAttributeUpdate(t.trim(), attributes);
                        ++n2;
                    }
                }
            }
            if ((exclude = (String)attrMap.get("exclude")) == null) continue;
            instance.marker.markUpdate(recursive, UpdateLevel.Skip, exclude.split(","));
        }
    }

    public static void addForValueChange(UIInput component) {
        PartialUpdateCandidates.getInstance().marker.markUpdate(new UIComponent[]{component});
        if (component.getValueChangeListener() != null || component.getValueChangeListeners().length > 0) {
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
        }
    }

    public static UpdateLevel decodeLevel(String lvlStr) {
        UpdateLevel level = UpdateLevel.Data;
        if (lvlStr != null) {
            String capitalized = String.valueOf(lvlStr.substring(0, 1).toUpperCase()) + lvlStr.substring(1).toLowerCase();
            try {
                level = UpdateLevel.valueOf(capitalized);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }
}

