/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.developer.ajax.encoder;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;

public class AjaxStyleEncoder
implements LiteAttributeEncoder {
    private static AjaxStyleEncoder instance = new AjaxStyleEncoder();

    private AjaxStyleEncoder() {
    }

    public static AjaxStyleEncoder getInstance() {
        return instance;
    }

    public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
        String styleStr = (String)component.getAttributes().get("style");
        if (styleStr != null) {
            String[] styleEntries = styleStr.split(";");
            StringBuffer buf = new StringBuffer();
            for (String entry : styleEntries) {
                String[] parts = entry.split(":");
                if (parts.length != 2 || parts[0].length() <= 0 || parts[1].length() <= 0) continue;
                buf.append(String.format("%s.getEl().setStyle('%s','%s');", jsvar, parts[0].trim(), parts[1].trim()));
            }
            if (buf.length() > 0) {
                out.writeScriptBlock(buf.toString());
            }
        }
    }
}

