/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.el;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.el.ELException;
import org.operamasks.el.resolver.BeanPropertyELResolver;
import org.operamasks.faces.annotation.Accessible;
import org.operamasks.faces.binding.ModelBean;

public class ManagedBeanPropertyELResolver
extends BeanPropertyELResolver {
    protected boolean fieldAccessible(Class baseClass, Field f) {
        if (Modifier.isPublic(f.getModifiers())) {
            return true;
        }
        if (this.getBeanProperty(baseClass, f.getName()) != null) {
            return false;
        }
        Accessible acc = f.getAnnotation(Accessible.class);
        if (acc != null) {
            return acc.value();
        }
        for (Annotation a : f.getAnnotations()) {
            Class<? extends Annotation> at = a.annotationType();
            if (!at.isAnnotationPresent(Accessible.class)) continue;
            return true;
        }
        return false;
    }

    protected Object getFieldValue(Field field, Object base) {
        return ModelBean.wrap(base).getField(field);
    }

    protected void setFieldValue(Field field, Object base, Object value) {
        ModelBean.wrap(base).setField(field, value);
    }

    protected Object getPropertyValue(Method method, Object base) {
        try {
            return method.invoke(base, new Object[0]);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }

    protected void setPropertyValue(Method method, Object base, Object value) {
        try {
            method.invoke(base, value);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }
}

