/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.lifecycle.requestlistener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.operamasks.faces.lifecycle.requestlistener.FacesRequestListener;
import org.operamasks.faces.util.LoggerUtil;

public class FacesRequestEventBroadcaster {
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.event");
    private List<FacesRequestListener> listeners = new ArrayList<FacesRequestListener>();

    public void addFacesRequestListener(FacesRequestListener listener) {
        this.listeners.add(listener);
    }

    public void removeFacesREquestListener(FacesRequestListener listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public void broadcastBeforeFacesContextCreate(ServletContext context) {
        for (FacesRequestListener listener : this.listeners) {
            try {
                listener.beforeFacesContextCreate(context);
            }
            catch (Throwable t) {
                this.log(listener, t);
            }
        }
    }

    public void broadcastAfterFacesContextCreate(FacesContext context) {
        for (FacesRequestListener listener : this.listeners) {
            try {
                listener.afterFacesContextCreate(context);
            }
            catch (Throwable t) {
                this.log(listener, t);
            }
        }
    }

    public void broadcastBeforeFacesContextRelease(FacesContext context) {
        for (FacesRequestListener listener : this.listeners) {
            try {
                listener.beforeFacesContextRelease(context);
            }
            catch (Throwable t) {
                this.log(listener, t);
            }
        }
    }

    public void broadcastAfterFacesContextRelease(ServletContext context) {
        for (FacesRequestListener listener : this.listeners) {
            try {
                listener.afterFacesContextRelease(context);
            }
            catch (Throwable t) {
                this.log(listener, t);
            }
        }
    }

    private void log(FacesRequestListener listener, Throwable throwable) {
        logger.log(Level.WARNING, "Exception occured in " + listener.getClass().getSimpleName(), throwable);
    }

    public void addFacesRequestListeners(FacesRequestListener[] listeners) {
        if (listeners != null) {
            this.listeners.addAll(Arrays.asList(listeners));
        }
    }
}

