/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;

public abstract class AbstractRenderKit
extends RenderKit {
    private static final String[] SUPPORTED_CONTENT_TYPES = new String[]{"text/html", "application/xhtml+xml", "application/xml", "text/xml", "*/*"};
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected Map<String, Map<String, Renderer>> familyMap = new HashMap<String, Map<String, Renderer>>();

    protected AbstractRenderKit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (family == null || rendererType == null || renderer == null) {
            throw new NullPointerException();
        }
        Map<String, Map<String, Renderer>> map = this.familyMap;
        synchronized (map) {
            Map<String, Renderer> rendererMap = this.familyMap.get(family);
            if (rendererMap == null) {
                rendererMap = new HashMap<String, Renderer>();
                this.familyMap.put(family, rendererMap);
            }
            rendererMap.put(rendererType, renderer);
        }
    }

    public Renderer getRenderer(String family, String rendererType) {
        return this.getPrivateRenderer(family, rendererType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Renderer getPrivateRenderer(String family, String rendererType) {
        if (family == null || rendererType == null) {
            throw new NullPointerException();
        }
        Map<String, Map<String, Renderer>> map = this.familyMap;
        synchronized (map) {
            Map<String, Renderer> rendererMap = this.familyMap.get(family);
            if (rendererMap == null) {
                return null;
            }
            Renderer renderer = rendererMap.get(rendererType);
            return renderer;
        }
    }

    protected abstract ResponseWriter implCreateResponseWriter(Writer var1, String var2, String var3);

    protected String[] getSupportedContentTypes() {
        return SUPPORTED_CONTENT_TYPES;
    }

    public ResponseWriter createResponseWriter(Writer writer, String desiredContentType, String encoding) {
        if (writer == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String[] supportedTypes = this.getSupportedContentTypes();
        String contentType = null;
        if (desiredContentType != null) {
            contentType = this.findMatch(desiredContentType, supportedTypes);
        } else {
            desiredContentType = context.getExternalContext().getResponseContentType();
            if (desiredContentType != null) {
                contentType = this.findMatch(desiredContentType, supportedTypes);
            }
            if (contentType == null) {
                String[] acceptTypes = (String[])context.getExternalContext().getRequestHeaderValuesMap().get("Accept");
                if (acceptTypes.length > 0) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(acceptTypes[0]);
                    for (int i = 1; i < acceptTypes.length; ++i) {
                        buf.append(',');
                        buf.append(acceptTypes[i]);
                    }
                    desiredContentType = buf.toString();
                } else {
                    desiredContentType = null;
                }
                contentType = desiredContentType != null ? this.findMatch(desiredContentType, supportedTypes) : DEFAULT_CONTENT_TYPE;
            }
        }
        if (contentType == null) {
            throw new IllegalArgumentException("The content type '" + desiredContentType + "' is not supported to create response writer.");
        }
        if (contentType.equals("*/*")) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        if (encoding != null) {
            if (!Charset.isSupported(encoding)) {
                throw new IllegalArgumentException("The character encoding '" + encoding + "' is not supported to create response writer.");
            }
        } else {
            encoding = context.getExternalContext().getResponseCharacterEncoding();
            if (encoding == null) {
                encoding = DEFAULT_ENCODING;
            }
        }
        return this.implCreateResponseWriter(writer, contentType, encoding);
    }

    private String findMatch(String desiredContentType, String[] supportedTypes) {
        String[] desiredTypes = desiredContentType.split(",");
        for (int i = 0; i < desiredTypes.length; ++i) {
            int semi = desiredTypes[i].indexOf(59);
            if (semi != -1) {
                desiredTypes[i] = desiredTypes[i].substring(0, semi);
            }
            desiredTypes[i] = desiredTypes[i].trim();
        }
        for (String curDesiredType : desiredTypes) {
            for (String curSupportedType : supportedTypes) {
                if (curDesiredType.indexOf(curSupportedType) == -1) continue;
                return curDesiredType;
            }
        }
        return null;
    }

    public ResponseStream createResponseStream(final OutputStream stream) {
        return new ResponseStream(){

            public void write(int b) throws IOException {
                stream.write(b);
            }

            public void write(byte[] b) throws IOException {
                stream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                stream.write(b, off, len);
            }

            public void flush() throws IOException {
                stream.flush();
            }

            public void close() throws IOException {
                stream.close();
            }
        };
    }
}

