/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.common;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.ButtonStub;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.encoder.HtmlAttributeEncoder;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.tools.annotation.Container;
import org.operamasks.faces.tools.annotation.ContainerItem;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

public final class RendererUtils {
    protected static final Logger log = LoggerUtil.getLogger("org.operamasks.faces.view");
    private static ConcurrentHashMap<String, String[][]> passthruAttributesWithExclusion = new ConcurrentHashMap();
    private static final String SUBMIT_FUNCTION_NAME = "_OM_submit";
    private static final String SUBMIT_FUNCTION = "function _OM_submit(id,params,target){\nvar f = document.forms[id];var t = f.target;var ap = new Array();if (target){f.target = target;}for (var i=0; i < params.length; i+=2){var p = document.createElement('input');p.type = 'hidden';p.name = params[i];p.value = params[i+1];f.appendChild(p);ap.push(p);}try{f.submit();}finally{f.target = t;for (var i = 0; i < ap.length; i++){f.removeChild(ap[i]);}}}";
    private static final String[][] PASSTHRU_ATTRIBUTES = new String[][]{{"accept", "accept"}, {"acceptcharset", "accept-charset"}, {"accesskey", "accesskey"}, {"align", "align"}, {"alt", "alt"}, {"bgcolor", "bgcolor"}, {"border", "border"}, {"cellpadding", "cellpadding"}, {"cellspacing", "cellspacing"}, {"charset", "charset"}, {"cols", "cols"}, {"colspan", "colspan"}, {"coords", "coords"}, {"dir", "dir"}, {"disabled", "disabled", "disabled"}, {"enctype", "enctype"}, {"frame", "frame"}, {"height", "height"}, {"hreflang", "hreflang"}, {"ismap", "ismap", "ismap"}, {"lang", "lang"}, {"longdesc", "longdesc"}, {"maxlength", "maxlength"}, {"onblur", "onblur"}, {"onchange", "onchange"}, {"onclick", "onclick"}, {"ondblclick", "ondblclick"}, {"onfocus", "onfocus"}, {"onkeydown", "onkeydown"}, {"onkeypress", "onkeypress"}, {"onkeyup", "onkeyup"}, {"onload", "onload"}, {"onmousedown", "onmousedown"}, {"onmousemove", "onmousemove"}, {"onmouseout", "onmouseout"}, {"onmouseover", "onmouseover"}, {"onmouseup", "onmouseup"}, {"onreset", "onreset"}, {"onselect", "onselect"}, {"onsubmit", "onsubmit"}, {"onunload", "onunload"}, {"readonly", "readonly", "readonly"}, {"rel", "rel"}, {"rev", "rev"}, {"rows", "rows"}, {"rowspan", "rowspan"}, {"rules", "rules"}, {"shape", "shape"}, {"size", "size"}, {"style", "style"}, {"styleClass", "class"}, {"summary", "summary"}, {"tabIndex", "tabindex"}, {"tabindex", "tabindex"}, {"target", "target"}, {"title", "title"}, {"usemap", "usemap"}, {"valign", "valign"}, {"width", "width"}};
    private static final String[] EMPTY_ELEMENTS = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
    public static final Map<String, LiteAttributeEncoder> HTML_LITE_ATTRIBUTES = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(){
        {
            for (String[] attribute : PASSTHRU_ATTRIBUTES) {
                this.put(attribute[0], new HtmlAttributeEncoder(attribute[0], attribute[1]));
            }
        }
    });

    public static boolean isContainer(UIComponent component) {
        return component.getClass().getAnnotation(Container.class) != null;
    }

    public static boolean isContainerItem(UIComponent component) {
        ContainerItem meta = component.getClass().getAnnotation(ContainerItem.class);
        return meta != null && meta.render();
    }

    public static UIComponent getLastContainerItem(UIComponent parent) {
        List children = parent.getChildren();
        for (int childPos = parent.getChildCount() - 1; childPos >= 0; --childPos) {
            if (!RendererUtils.isContainerItem((UIComponent)children.get(childPos))) continue;
            return (UIComponent)children.get(childPos);
        }
        return null;
    }

    public static HtmlBasicRendererBase getHtmlBasicRenderer(UIComponent component) {
        try {
            return (HtmlBasicRendererBase)FacesUtils.getRenderKit(FacesContext.getCurrentInstance(), "HTML_BASIC").getRenderer(component.getFamily(), component.getRendererType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not find the HTML_BASIC renderer of " + component);
        }
    }

    public static String allocVariable(FacesContext contxt, UIComponent component) {
        ResourceManager rm = ResourceManager.getInstance(contxt);
        return ComponentResource.registerJS(rm, new String[0]).allocVariable(component);
    }

    public static void addOperationScript(String script) {
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager.getInstance(context).addOperationScript(script);
    }

    public static void addLastScript(String script) {
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager.getInstance(context).addLastScript(script);
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String newValue = (String)submittedValue;
        ValueExpression binding = component.getValueExpression("value");
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            if (binding == null) {
                return newValue;
            }
            Class valueType = binding.getType(context.getELContext());
            if (valueType == null || valueType == String.class || valueType == Object.class) {
                return newValue;
            }
            converter = context.getApplication().createConverter(valueType);
            if (converter == null) {
                throw new ConverterException(Resources._T("JSF_NO_SUCH_CONVERTER_TYPE", valueType.getName()));
            }
        }
        return converter.getAsObject(context, component, newValue);
    }

    public static boolean isEmptyElement(String name) {
        return Arrays.binarySearch(EMPTY_ELEMENTS, name.toLowerCase()) >= 0;
    }

    public static String getActionURL(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(url);
    }

    public static String encodeSubmit(FacesContext context, UIForm form, String target, String ... params) {
        RendererUtils.encodeSubmitFunction(context);
        StringBuilder buf = new StringBuilder();
        buf.append(SUBMIT_FUNCTION_NAME);
        buf.append("('").append(form.getClientId(context)).append("',[");
        for (int i = 0; i < params.length; i += 2) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(params[i]).append(",").append(params[i + 1]);
        }
        buf.append("]");
        if (target != null) {
            buf.append(",'").append(target).append("'");
        }
        buf.append(");");
        return buf.toString();
    }

    public static String encodeAjaxSubmit(FacesContext context, UIComponent component, String jsvar, String ... params) {
        UIForm form = FacesUtils.getParentForm(component);
        boolean immediate = component instanceof UICommand ? ((UICommand)component).isImmediate() : false;
        StringBuilder buf = new StringBuilder();
        String functionName = "OM.ES(";
        if (form != null || params.length != 0 || immediate) {
            if (form != null) {
                buf.append("'").append(form.getClientId(context)).append("',");
            } else {
                buf.append("null,");
            }
            String clientId = "'" + component.getClientId(context) + "'";
            if (params.length == 0) {
                buf.append("null,");
            } else if (params.length == 2 && params[0].equals(clientId) && params[1].startsWith("'")) {
                buf.append(params[1]).append(",");
            } else {
                buf.append("{");
                for (int i = 0; i < params.length; i += 2) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append(params[i]);
                    buf.append(":");
                    buf.append(params[i + 1]);
                }
                buf.append("},");
            }
            if (immediate) {
                functionName = functionName.substring(0, 5) + "I" + functionName.substring(5);
            }
            buf.append(clientId);
            if (component instanceof ButtonStub) {
                buf.append(",").append(Aliases.getVar(jsvar));
            }
        }
        buf.append(");");
        return functionName + buf.toString();
    }

    public static boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled != null) {
            if (disabled instanceof String) {
                return ((String)disabled).equalsIgnoreCase("true");
            }
            return disabled.equals(Boolean.TRUE);
        }
        return false;
    }

    public static boolean isReadonly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly != null) {
            if (readonly instanceof String) {
                return ((String)readonly).equalsIgnoreCase("true");
            }
            return readonly.equals(Boolean.TRUE);
        }
        return false;
    }

    public static boolean isDisabledOrReadonly(UIComponent component) {
        return RendererUtils.isDisabled(component) || RendererUtils.isReadonly(component);
    }

    public static boolean needsEscape(UIComponent component) {
        Object escape = component.getAttributes().get("escape");
        if (escape != null) {
            if (escape instanceof String) {
                return ((String)escape).equalsIgnoreCase("true");
            }
            return escape.equals(Boolean.TRUE);
        }
        return false;
    }

    public static boolean shouldWriteIdAttribute(FacesContext context, UIComponent component) {
        if (component.isTransient()) {
            return false;
        }
        if (FacesUtils.isAjaxResponse(context) || FacesUtils.isAjaxHtmlResponse(context)) {
            return true;
        }
        String id = component.getId();
        return id != null && !id.startsWith("j_id");
    }

    public static boolean writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        if (RendererUtils.shouldWriteIdAttribute(context, component)) {
            String id = component.getClientId(context);
            writer.writeAttribute("id", (Object)id, "clientId");
            return true;
        }
        return false;
    }

    public static boolean hasPassThruAttributes(UIComponent component) {
        return RendererUtils.hasPassThruAttributes(component, null);
    }

    public static boolean hasPassThruAttributes(UIComponent component, String exclusion) {
        if (component == null) {
            return false;
        }
        Map attrs = component.getAttributes();
        for (String[] attribute : RendererUtils.getPassThruAttributes(exclusion)) {
            Object value = attrs.get(attribute[0]);
            if (value == null || "".equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        RendererUtils.renderPassThruAttributes(writer, component, null);
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component, String exclusion) throws IOException {
        for (String[] attribute : RendererUtils.getPassThruAttributes(exclusion)) {
            Object value = component.getAttributes().get(attribute[0]);
            if (value == null) continue;
            if (attribute.length == 3) {
                Boolean result = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(value.toString());
                writer.writeAttribute(attribute[1], (Object)result, attribute[0]);
                continue;
            }
            if (!RendererUtils.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute[1], (Object)value.toString(), attribute[0]);
        }
    }

    private static void encodeSubmitFunction(FacesContext context) {
        ResourceManager rm = ResourceManager.getInstance(context);
        rm.registerResource(new AbstractResource("urn:function:submit_form"){

            public void encodeEnd(FacesContext context) throws IOException {
                ResponseWriter out = context.getResponseWriter();
                out.startElement("script", null);
                out.writeAttribute("type", (Object)"text/javascript", null);
                out.writeAttribute("language", (Object)"Javascript", null);
                out.write(RendererUtils.SUBMIT_FUNCTION);
                out.endElement("script");
            }
        });
    }

    private static String[][] getPassThruAttributes(String exclusion) {
        if (exclusion == null) {
            return PASSTHRU_ATTRIBUTES;
        }
        String[][] passthruAttributes = passthruAttributesWithExclusion.get(exclusion);
        if (passthruAttributes == null) {
            String[] excludes = exclusion.split(",");
            passthruAttributes = new String[PASSTHRU_ATTRIBUTES.length - excludes.length][];
            int next = 0;
            for (int i = 0; i < PASSTHRU_ATTRIBUTES.length; ++i) {
                String name = PASSTHRU_ATTRIBUTES[i][0];
                boolean skip = false;
                for (int j = 0; j < excludes.length; ++j) {
                    if (!name.equals(excludes[j])) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                passthruAttributes[next++] = PASSTHRU_ATTRIBUTES[i];
            }
            assert (next == passthruAttributes.length);
            passthruAttributesWithExclusion.put(exclusion, passthruAttributes);
        }
        return passthruAttributes;
    }

    private static boolean shouldRenderAttribute(Object attributeValue) {
        switch (TypeCoercion.typeof((Object)attributeValue)) {
            case 1: {
                return (Boolean)attributeValue != false;
            }
            case 2: {
                return (Byte)attributeValue != -128;
            }
            case 3: {
                return ((Character)attributeValue).charValue() != '\u0000';
            }
            case 4: {
                return (Short)attributeValue != Short.MIN_VALUE;
            }
            case 5: {
                return (Integer)attributeValue != Integer.MIN_VALUE;
            }
            case 6: {
                return (Long)attributeValue != Long.MIN_VALUE;
            }
            case 7: {
                return ((Float)attributeValue).floatValue() != Float.MIN_VALUE;
            }
            case 8: {
                return (Double)attributeValue != Double.MIN_VALUE;
            }
        }
        return true;
    }

    public static String encodeComponent(FacesContext context, UIComponent component) {
        StringWriter strWriter = new StringWriter();
        ResponseWriter bufWriter = RendererUtils.createHtmlResponseWriter(context, strWriter);
        ResponseWriter curWriter = context.getResponseWriter();
        try {
            context.setResponseWriter(bufWriter);
            component.encodeAll(context);
            String string = strWriter.toString();
            return string;
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
        finally {
            if (curWriter != null) {
                context.setResponseWriter(curWriter);
            }
        }
    }

    public static String encodeComponentChildren(FacesContext context, UIComponent component) {
        if (component.getChildCount() == 0) {
            return "";
        }
        StringWriter strWriter = new StringWriter();
        ResponseWriter bufWriter = RendererUtils.createHtmlResponseWriter(context, strWriter);
        ResponseWriter curWriter = context.getResponseWriter();
        try {
            context.setResponseWriter(bufWriter);
            for (UIComponent kid : component.getChildren()) {
                kid.encodeAll(context);
            }
            String i$ = strWriter.toString();
            return i$;
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
        finally {
            if (curWriter != null) {
                context.setResponseWriter(curWriter);
            }
        }
    }

    private static ResponseWriter createHtmlResponseWriter(FacesContext context, Writer writer) {
        RenderKit rk = RendererUtils.getRenderKit(context, "HTML_BASIC");
        return rk.createResponseWriter(writer, null, null);
    }

    public static RenderKit getRenderKit(FacesContext context, String renderKitId) {
        RenderKit renderKit = null;
        if (renderKitId != null) {
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            renderKit = factory.getRenderKit(context, renderKitId);
        }
        if (renderKit == null) {
            throw new IllegalArgumentException("Can not find RenderKit '" + renderKitId + "'");
        }
        return renderKit;
    }

    public static String getFormattedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        Converter converter = RendererUtils.getConverter(context, component, value);
        if (converter != null) {
            String formattedValue = converter.getAsString(context, component, value);
            return formattedValue == null ? "" : formattedValue;
        }
        return value == null ? "" : value.toString();
    }

    private static Converter getConverter(FacesContext context, UIComponent component, Object value) {
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && value != null && !(value instanceof String)) {
            converter = context.getApplication().createConverter(value.getClass());
        }
        return converter;
    }

    public static boolean isMSIE(FacesContext context) {
        String ua = (String)context.getExternalContext().getRequestHeaderMap().get("User-Agent");
        if (ua != null) {
            return (ua = ua.toLowerCase()).indexOf("msie") != -1 && ua.indexOf("opera") == -1;
        }
        return false;
    }

    public static void sendScript(String script) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!(context.getResponseWriter() instanceof AjaxResponseWriter)) {
            throw new IllegalArgumentException("writer must be AjaxResponseWriter");
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        out.setViewStateChanged();
        out.writeActionScript(script);
    }

    public static UIForm getParentForm(UIComponent component) {
        while (component != null) {
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static boolean isHtmlResponse(FacesContext context) {
        return context.getResponseWriter() instanceof HtmlResponseWriter;
    }

    public static boolean isAjaxHtmlResponse(FacesContext context) {
        return context.getResponseWriter() instanceof AjaxHtmlResponseWriter;
    }

    public static boolean isAjaxResponse(FacesContext context) {
        return context.getResponseWriter() instanceof AjaxResponseWriter;
    }

    public static boolean shouldComponentBeRendered(UIComponent component) {
        if (!component.isRendered()) {
            return false;
        }
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.isRendered()) continue;
            return false;
        }
        return true;
    }

    public static String getIcon(UIComponent component) {
        String image = (String)component.getAttributes().get("image");
        if (image != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (image.startsWith(context.getExternalContext().getRequestContextPath())) {
                return image;
            }
            return context.getApplication().getViewHandler().getResourceURL(context, image);
        }
        return null;
    }

    public static boolean flag(FacesContext context, String key) {
        Map reqMap = context.getExternalContext().getRequestMap();
        boolean result = reqMap.containsKey(key);
        if (!result) {
            reqMap.put(key, true);
        }
        return result;
    }

    public static String getJsvarAliasDef(String jsvar, Aliases alias) {
        if (jsvar.length() < 8) {
            return "";
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (!Aliases.isDisabled(context)) {
            StringBuilder s = new StringBuilder();
            s.append(alias.var(jsvar)).append("=");
            return s.toString();
        }
        return "";
    }
}

