/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.UISelectRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxListRenderer
extends UISelectRenderer {
    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        List<SelectItem> items = this.getSelectItems(context, component);
        this.renderCheckboxList(context, component, items);
    }

    public void renderCheckboxList(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        String layout = (String)component.getAttributes().get("layout");
        boolean vertical = "pageDirection".equalsIgnoreCase(layout);
        int border = 0;
        Object borderObj = component.getAttributes().get("border");
        if (borderObj instanceof Integer) {
            border = (Integer)borderObj;
        } else if (borderObj != null) {
            try {
                border = Integer.valueOf(borderObj.toString());
            }
            catch (Exception ex) {
                border = 0;
            }
        }
        ResponseWriter out = context.getResponseWriter();
        int idx = 0;
        this.renderTableBegin(context, component, border, vertical, true);
        for (SelectItem item : items) {
            if (item instanceof SelectItemGroup) {
                if (item.getLabel() != null) {
                    if (vertical) {
                        out.startElement("tr", component);
                    }
                    out.startElement("td", component);
                    out.writeText((Object)item.getLabel(), "label");
                    out.endElement("td");
                    if (vertical) {
                        out.endElement("tr");
                    }
                }
                if (vertical) {
                    out.startElement("tr", component);
                }
                out.startElement("td", component);
                this.renderTableBegin(context, component, 0, vertical, false);
                for (SelectItem groupItem : ((SelectItemGroup)item).getSelectItems()) {
                    this.renderOption(context, component, groupItem, vertical, idx++);
                }
                this.renderTableEnd(context, component, vertical, false);
                out.endElement("td");
                if (!vertical) continue;
                out.endElement("tr");
                continue;
            }
            this.renderOption(context, component, item, vertical, idx++);
        }
        this.renderTableEnd(context, component, vertical, true);
    }

    private void renderTableBegin(FacesContext context, UIComponent component, int border, boolean vertical, boolean outerTable) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("table", component);
        if (border != Integer.MIN_VALUE) {
            out.writeAttribute("border", (Object)border, "border");
        }
        if (outerTable) {
            String styleClass = (String)component.getAttributes().get("styleClass");
            String style = (String)component.getAttributes().get("style");
            RendererUtils.writeIdAttributeIfNecessary(context, out, component);
            if (styleClass != null) {
                out.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            if (style != null) {
                out.writeAttribute("style", (Object)style, "style");
            }
        }
        if (!vertical) {
            out.startElement("tr", component);
        }
    }

    protected void renderTableEnd(FacesContext context, UIComponent component, boolean vertical, boolean outerTable) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (!vertical) {
            out.endElement("tr");
        }
        out.endElement("table");
    }

    protected void renderOption(FacesContext context, UIComponent component, SelectItem item, boolean vertical, int itemNum) throws IOException {
        boolean disabled;
        ResponseWriter out = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String itemId = clientId + ':' + itemNum;
        String itemValueStr = this.getFormattedValue(context, component, item.getValue());
        boolean selected = this.isSelected(context, component, item.getValue(), itemValueStr);
        boolean bl = disabled = item.isDisabled() || RendererUtils.isDisabled(component);
        if (vertical) {
            out.startElement("tr", component);
        }
        out.startElement("td", component);
        out.startElement("input", component);
        out.writeAttribute("type", (Object)this.getOptionType(), null);
        out.writeAttribute("id", (Object)itemId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        out.writeAttribute("value", (Object)itemValueStr, "value");
        out.writeAttribute(this.getSelectedOption(), (Object)selected, "value");
        out.writeAttribute("disabled", (Object)disabled, "disabled");
        RendererUtils.renderPassThruAttributes(out, component, "style,styleClass,disabled,border");
        out.endElement("input");
        if (item.getLabel() != null) {
            String labelClass = null;
            labelClass = RendererUtils.isDisabled(component) || item.isDisabled() ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
            out.startElement("label", component);
            out.writeAttribute("for", (Object)itemId, "for");
            if (labelClass != null) {
                out.writeAttribute("class", (Object)labelClass, "labelClass");
            }
            if (item.getDescription() != null) {
                out.writeAttribute("title", (Object)item.getDescription(), "title");
            }
            out.writeText((Object)" ", null);
            out.writeText((Object)item.getLabel(), "label");
            out.endElement("label");
        }
        out.endElement("td");
        if (vertical) {
            out.endElement("tr");
        }
    }

    protected String getOptionType() {
        return "checkbox";
    }

    public String getSelectedOption() {
        return "checked";
    }
}

