/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.common.RendererUtils;

public class CommandButtonRenderer
extends HtmlBasicRendererBase {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (!(paramMap.containsKey(clientId) || paramMap.containsKey(clientId + ".x") || paramMap.containsKey(clientId + ".y"))) {
            return;
        }
        String type = (String)component.getAttributes().get("type");
        if (type != null && type.equalsIgnoreCase("reset")) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(component);
        component.queueEvent((FacesEvent)actionEvent);
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        String type = (String)component.getAttributes().get("type");
        if (type == null) {
            type = "submit";
        }
        String label = this.getLabel(context, component);
        String imageSrc = (String)component.getAttributes().get("image");
        ResponseWriter out = context.getResponseWriter();
        out.startElement("input", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        if (imageSrc != null) {
            out.writeAttribute("type", (Object)"image", "type");
            out.writeAttribute("name", (Object)clientId, "clientId");
            out.writeURIAttribute("src", (Object)this.src(context, imageSrc), "image");
        } else {
            out.writeAttribute("type", (Object)type.toLowerCase(), "type");
            out.writeAttribute("name", (Object)clientId, "clientId");
            out.writeAttribute("value", (Object)label, "value");
        }
        String onclick = this.getOnclickScript(context, component);
        if (onclick != null) {
            out.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        RendererUtils.renderPassThruAttributes(out, component, "onclick");
        out.endElement("input");
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    private String getLabel(FacesContext context, UIComponent component) {
        Object value = ((UICommand)component).getValue();
        if (value != null) {
            return value.toString();
        }
        return FacesUtils.encodeComponentChildren(context, component);
    }

    private String src(FacesContext context, String value) {
        if (value == null) {
            return "";
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }

    protected String getOnclickScript(FacesContext context, UIComponent component) {
        return (String)component.getAttributes().get("onclick");
    }
}

