/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkRenderer
extends HtmlBasicRendererBase {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            ActionEvent event = new ActionEvent(component);
            component.queueEvent((FacesEvent)event);
        }
    }

    @Override
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UIForm form = FacesUtils.getParentForm(component);
        if (RendererUtils.isDisabled(component)) {
            this.renderDisabledLink(context, component);
        } else if (form != null) {
            this.renderActiveLink(context, form, component);
        } else if (FacesUtils.isTransientStateSupported(context)) {
            this.renderSingleLink(context, component);
        }
    }

    @Override
    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    @Override
    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        String label = this.getLabel(component);
        if (label != null) {
            ResponseWriter out = context.getResponseWriter();
            out.writeText((Object)label, "value");
        } else {
            super.__invokeChildrenHtmlRendering(context, component);
        }
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        UIForm form = FacesUtils.getParentForm(component);
        ResponseWriter out = context.getResponseWriter();
        if (RendererUtils.isDisabled(component)) {
            out.endElement("span");
        } else if (form != null || FacesUtils.isTransientStateSupported(context)) {
            out.endElement("a");
        }
    }

    protected void renderDisabledLink(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String type = (String)component.getAttributes().get("type");
        out.startElement("span", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        if (type != null) {
            out.writeAttribute("type", (Object)type, "type");
        }
        RendererUtils.renderPassThruAttributes(out, component, "disabled");
    }

    protected void renderActiveLink(FacesContext context, UIForm form, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String onclick = this.getOnclickScript(context, form, component, true);
        String type = (String)component.getAttributes().get("type");
        out.startElement("a", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        out.writeAttribute("href", (Object)"#", null);
        out.writeAttribute("onclick", (Object)onclick, "onclick");
        if (type != null) {
            out.writeAttribute("type", (Object)type, "type");
        }
        RendererUtils.renderPassThruAttributes(out, component, "disabled,onclick,target");
    }

    protected void renderSingleLink(FacesContext context, UIComponent component) throws IOException {
        StringBuilder urlbuf = new StringBuilder();
        urlbuf.append(RendererUtils.getActionURL(context));
        urlbuf.append('?');
        urlbuf.append(HtmlEncoder.encodeURIComponent(component.getClientId(context)));
        urlbuf.append('=');
        urlbuf.append('&');
        urlbuf.append("javax.faces.ViewId");
        urlbuf.append('=');
        urlbuf.append(HtmlEncoder.encodeURIComponent(context.getViewRoot().getViewId()));
        for (UIParameter param : this.getParameters(component)) {
            if (param.getName() == null || param.getValue() == null) continue;
            urlbuf.append('&');
            urlbuf.append(HtmlEncoder.encodeURIComponent(param.getName()));
            urlbuf.append('=');
            urlbuf.append(HtmlEncoder.encodeURIComponent(param.getValue().toString()));
        }
        String type = (String)component.getAttributes().get("type");
        ResponseWriter out = context.getResponseWriter();
        out.startElement("a", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        out.writeAttribute("href", (Object)urlbuf.toString(), null);
        if (type != null) {
            out.writeAttribute("type", (Object)type, "type");
        }
        RendererUtils.renderPassThruAttributes(out, component, "disabled");
    }

    protected String getOnclickScript(FacesContext context, UIForm form, UIComponent component, boolean doReturn) {
        String clientId = component.getClientId(context);
        String userOnclick = (String)component.getAttributes().get("onclick");
        if (userOnclick != null && (userOnclick = userOnclick.trim()).length() == 0) {
            userOnclick = null;
        }
        StringBuilder sb = new StringBuilder();
        if (userOnclick != null) {
            sb.append("var a=function(){");
            sb.append(userOnclick);
            if (!userOnclick.endsWith(";")) {
                sb.append(';');
            }
            sb.append("};var b=function(){");
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(HtmlEncoder.enquote(clientId));
        paramList.add("''");
        for (UIParameter param : this.getParameters(component)) {
            if (param.getName() == null || param.getValue() == null) continue;
            paramList.add(HtmlEncoder.enquote(param.getName()));
            paramList.add(HtmlEncoder.enquote(param.getValue().toString()));
        }
        String[] params = paramList.toArray(new String[paramList.size()]);
        String target = (String)component.getAttributes().get("target");
        sb.append(RendererUtils.encodeSubmit(context, form, target, params));
        if (doReturn) {
            sb.append("return false;");
        }
        if (userOnclick != null) {
            sb.append("};");
            if (doReturn) {
                sb.append("return (a.apply(this)==false)?false:b();");
            } else {
                sb.append("a.apply(this)==false||b();");
            }
        }
        return sb.toString();
    }

    private String getLabel(UIComponent component) {
        Object value;
        String label = null;
        if (component instanceof UICommand) {
            Object value2 = ((UICommand)component).getValue();
            if (value2 != null) {
                label = value2.toString();
            }
        } else if (component instanceof ValueHolder && (value = ((ValueHolder)component).getValue()) != null) {
            label = value.toString();
        }
        return label;
    }

    protected List<UIParameter> getParameters(UIComponent component) {
        ArrayList<UIParameter> paramList = new ArrayList<UIParameter>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            paramList.add((UIParameter)kid);
        }
        return paramList;
    }
}

