/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.resources.Resources;

public class FormRenderer
extends HtmlBasicRendererBase {
    private static final String SUPPORT_SCRIPTS_ATTR = "org.operamasks.faces.SUPPORT_SCRIPTS";
    private static final String HIDDEN_FIELDS_ATTR = "org.operamasks.faces.HIDDEN_FIElDS";
    private static final String TRANSIENT_FORM_PARAM = "org.operamasks.faces.TRANSIENT_FORM";
    private static final String FORM_RICH_PARAM = "org.operamasks.faces.FORM_RICH";

    public void decode(FacesContext context, UIComponent component) {
        String postback = FormRenderer.getPostbackFieldName(context, component);
        if (context.getExternalContext().getRequestParameterMap().containsKey(postback)) {
            ((UIForm)component).setSubmitted(true);
            PartialUpdateCandidates.getInstance().markSubmitForm(component);
        } else {
            ((UIForm)component).setSubmitted(false);
        }
    }

    private boolean hasFormParent(UIComponent component) {
        while (component != null) {
            if (!((component = component.getParent()) instanceof UIForm)) continue;
            return true;
        }
        return false;
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (this.hasFormParent(component)) {
            throw new FacesException(Resources._T("JSF_NESTED_FORM"));
        }
        ResponseWriter out = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String method = null;
        if (FormRenderer.isTransientFormSupported()) {
            method = component.getAttributes().get("method");
        }
        if (method == null) {
            method = "post";
        }
        out.startElement("form", component);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        out.writeAttribute("method", (Object)method, null);
        out.writeAttribute("action", (Object)RendererUtils.getActionURL(context), null);
        RendererUtils.renderPassThruAttributes(out, component);
        out.writeText((Object)"\n", null);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        this.renderHtmlBeginSection(context, component, out);
        this.renderHtmlMiddleSection(context, component, out);
        this.renderHtmlEndSection(context, component, out);
    }

    public void renderHtmlBeginSection(FacesContext context, UIComponent component, ResponseWriter out) throws IOException {
        this.renderHiddenFields(context, component);
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("name", (Object)FormRenderer.getPostbackFieldName(context, component), null);
        out.endElement("input");
    }

    public void renderHtmlMiddleSection(FacesContext context, UIComponent component, ResponseWriter out) throws IOException {
        if (FormRenderer.isTransientForm((UIForm)component)) {
            out.startElement("input", component);
            out.writeAttribute("type", (Object)"hidden", null);
            out.writeAttribute("name", (Object)"javax.faces.ViewId", null);
            out.writeAttribute("value", (Object)context.getViewRoot().getViewId(), null);
            out.endElement("input");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderHtmlEndSection(FacesContext context, UIComponent component, ResponseWriter out) throws IOException {
        if (FormRenderer.isTransientForm((UIForm)component)) {
            try {
                FacesUtils.markForTransientState(context);
                context.getApplication().getViewHandler().writeState(context);
            }
            finally {
                FacesUtils.unmarkTransientState(context);
            }
        } else {
            context.getApplication().getViewHandler().writeState(context);
        }
        out.endElement("form");
        this.renderScripts(context, component);
    }

    public static boolean isTransientForm(UIForm form) {
        if (!FormRenderer.isTransientFormSupported()) {
            return false;
        }
        if (form.isTransient()) {
            return true;
        }
        Object method = form.getAttributes().get("method");
        if (method != null && "get".equalsIgnoreCase(method.toString())) {
            return true;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String param = context.getExternalContext().getInitParameter(TRANSIENT_FORM_PARAM);
        return param != null && "true".equalsIgnoreCase(param);
    }

    public static boolean isTransientFormSupported() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getViewHandler() instanceof ViewBuilder;
    }

    public void renderScripts(FacesContext context, UIComponent form) throws IOException {
        String key;
        Map requestMap = context.getExternalContext().getRequestMap();
        String supportScripts = (String)requestMap.get(key = SUPPORT_SCRIPTS_ATTR + form.getClientId(context));
        if (supportScripts != null) {
            ResponseWriter out = context.getResponseWriter();
            out.startElement("script", null);
            out.writeAttribute("type", (Object)"text/javascript", null);
            out.writeAttribute("language", (Object)"Javascript", null);
            out.write(supportScripts);
            out.endElement("script");
            requestMap.remove(key);
        }
    }

    private void renderHiddenFields(FacesContext context, UIComponent form) throws IOException {
        String key;
        Map requestMap = context.getExternalContext().getRequestMap();
        Map hiddenFields = (Map)requestMap.get(key = HIDDEN_FIELDS_ATTR + form.getClientId(context));
        if (hiddenFields != null) {
            ResponseWriter out = context.getResponseWriter();
            for (Map.Entry entry : hiddenFields.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                out.startElement("input", null);
                out.writeAttribute("type", (Object)"hidden", null);
                out.writeAttribute("name", (Object)name, null);
                out.writeAttribute("value", (Object)value, null);
                out.endElement("input");
            }
        }
    }

    public static void addSupportScript(UIForm form, String script) {
        String key;
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        String supportScripts = (String)requestMap.get(key = SUPPORT_SCRIPTS_ATTR + form.getClientId(context));
        supportScripts = supportScripts == null ? script : supportScripts + script;
        requestMap.put(key, supportScripts);
    }

    public static void addHiddenFields(UIForm form, String name, String value) {
        String key;
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap<String, String> hiddenFields = (HashMap<String, String>)requestMap.get(key = HIDDEN_FIELDS_ATTR + form.getClientId(context));
        if (hiddenFields == null) {
            hiddenFields = new HashMap<String, String>();
            requestMap.put(key, hiddenFields);
        }
        hiddenFields.put(name, value);
    }

    public static String getPostbackFieldName(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        return clientId + ':' + "_postback";
    }
}

