/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import org.operamasks.faces.util.Base64;
import org.operamasks.resources.Resources;

public class HtmlResponseStateManager
extends ResponseStateManager {
    private static final String STATE_SAVING_COMPRESSED_PARAM = "org.operamasks.faces.STATE_SAVING_COMPRESSED";
    private static final String STATE_SAVING_PASSWORD_PARAM = "org.operamasks.faces.STATE_SAVING_PASSWORD";
    private boolean compressed = true;
    private boolean encrypted = false;
    private static final String SECRET_KEY_ALGORITHM = "DESede";
    private static final String CIPHER_ALGORITHM = "DESede/CBC/PKCS5Padding";
    private static final String MAC_ALGORITHM = "HmacSHA1";
    private static final int KEY_LENGTH = 24;
    private static final int MAC_LENGTH = 20;
    private static final int IV_LENGTH = 8;
    private static final int MAC_OFFSET = 0;
    private static final int DATA_OFFSET = 20;
    private SecureRandom random;
    private SecretKey cipherKey;
    private SecretKeySpec macKey;
    private IvParameterSpec iv;

    public HtmlResponseStateManager() {
        this.init();
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        StateManager stateManager;
        String viewState = state == null ? null : (state instanceof String ? (String)state : ((stateManager = context.getApplication().getStateManager()).isSavingStateInClient(context) ? this.encodeViewState(state) : context.getViewRoot().getViewId()));
        String renderKitId = context.getApplication().getDefaultRenderKitId();
        if (renderKitId != null && renderKitId.equals("HTML_BASIC")) {
            renderKitId = null;
        }
        if (viewState != null || renderKitId != null) {
            this.writeState(context, viewState, renderKitId);
        }
    }

    protected void writeState(FacesContext context, String viewState, String renderKitId) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (viewState != null) {
            out.startElement("input", (UIComponent)context.getViewRoot());
            out.writeAttribute("type", (Object)"hidden", null);
            out.writeAttribute("name", (Object)"javax.faces.ViewState", null);
            out.writeAttribute("value", (Object)viewState, null);
            out.endElement("input");
        }
        if (renderKitId != null) {
            out.startElement("input", (UIComponent)context.getViewRoot());
            out.writeAttribute("type", (Object)"hidden", null);
            out.writeAttribute("name", (Object)"javax.faces.RenderKitId", null);
            out.writeAttribute("value", (Object)renderKitId, null);
            out.endElement("input");
        }
    }

    public Object getState(FacesContext context, String viewId) {
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String viewString = (String)requestParamMap.get("javax.faces.ViewState");
        if (viewString == null || viewString.length() == 0) {
            return null;
        }
        StateManager stateManager = context.getApplication().getStateManager();
        if (stateManager.isSavingStateInClient(context)) {
            try {
                return this.decodeViewState(viewString);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        return viewString;
    }

    public boolean isPostback(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        return paramMap.containsKey("javax.faces.ViewState") || paramMap.containsKey("javax.faces.ViewId");
    }

    private String encodeViewState(Object state) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = this.compressed ? new ObjectOutputStream(new GZIPOutputStream(bout)) : new ObjectOutputStream(bout);
        out.writeObject(state);
        out.close();
        byte[] bytes = bout.toByteArray();
        if (this.encrypted) {
            bytes = this.encrypt(bytes);
        }
        return Base64.encode(bytes);
    }

    private Object decodeViewState(String viewString) throws IOException, ClassNotFoundException {
        byte[] bytes = Base64.decode(viewString);
        if (this.encrypted) {
            bytes = this.decrypt(bytes);
        }
        InputStream bin = new ByteArrayInputStream(bytes);
        if (this.compressed) {
            bin = new GZIPInputStream(bin);
        }
        final ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ObjectInputStream in = new ObjectInputStream(bin){

            protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                return Class.forName(desc.getName(), true, contextLoader);
            }
        };
        return in.readObject();
    }

    private byte[] encrypt(byte[] plainText) {
        try {
            Cipher cipher = this.getCipher(1);
            Mac mac = this.getMac();
            byte[] encrypted = cipher.doFinal(plainText);
            mac.update(encrypted);
            byte[] macBytes = mac.doFinal();
            assert (macBytes.length == 20);
            byte[] result = new byte[20 + encrypted.length];
            System.arraycopy(macBytes, 0, result, 0, 20);
            System.arraycopy(encrypted, 0, result, 20, encrypted.length);
            return result;
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private byte[] decrypt(byte[] secureText) throws IOException {
        try {
            Cipher cipher = this.getCipher(2);
            Mac mac = this.getMac();
            mac.update(secureText, 20, secureText.length - 20);
            byte[] macBytes = mac.doFinal();
            assert (macBytes.length == 20);
            for (int i = 0; i < 20; ++i) {
                if (macBytes[i] == secureText[i + 0]) continue;
                throw new IOException(Resources._T("JSF_VIEW_STATE_TAMPERED"));
            }
            return cipher.doFinal(secureText, 20, secureText.length - 20);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private void init() {
        String compression = null;
        String password = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            ExternalContext ectx = context.getExternalContext();
            compression = ectx.getInitParameter(STATE_SAVING_COMPRESSED_PARAM);
            password = ectx.getInitParameter(STATE_SAVING_PASSWORD_PARAM);
        }
        if (compression != null) {
            this.compressed = Boolean.valueOf(compression);
        }
        if (password != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                byte[] seed = md.digest(password.getBytes());
                this.random = SecureRandom.getInstance("SHA1PRNG");
                this.random.setSeed(seed);
                byte[] rawKey = new byte[24];
                byte[] rawIv = new byte[8];
                byte[] rawMacKey = new byte[20];
                this.random.nextBytes(rawKey);
                this.random.nextBytes(rawIv);
                this.random.nextBytes(rawMacKey);
                SecretKeyFactory keygen = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
                DESedeKeySpec keyspec = new DESedeKeySpec(rawKey);
                this.cipherKey = keygen.generateSecret(keyspec);
                this.macKey = new SecretKeySpec(rawMacKey, MAC_ALGORITHM);
                this.iv = new IvParameterSpec(rawIv);
                this.encrypted = true;
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    private Cipher getCipher(int mode) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(mode, (Key)this.cipherKey, this.iv, this.random);
            return cipher;
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private Mac getMac() {
        try {
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(this.macKey);
            return mac;
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        Object[] state = new Object[]{view.getStructure(), view.getState()};
        this.writeState(context, state);
    }

    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        Object state = this.getState(context, viewId);
        if (state instanceof Object[]) {
            Object[] stateArray = (Object[])state;
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put("javax.faces.ViewState", stateArray[1]);
            return stateArray[0];
        }
        return state;
    }

    public Object getComponentStateToRestore(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object state = requestMap.get("javax.faces.ViewState");
        requestMap.remove("javax.faces.ViewState");
        return state;
    }
}

