/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.Formatter;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.html.UIOutputRenderer;

public class LabelRenderer
extends UIOutputRenderer
implements ToolBarItemRenderer {
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String forClientId = LabelRenderer.getForComponentClientId(context, component);
        out.startElement("label", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        if (forClientId != null) {
            out.writeAttribute("for", (Object)forClientId, "for");
        }
        RendererUtils.renderPassThruAttributes(out, component);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        Object value = this.getValue(component);
        if (value == null) {
            super.__invokeChildrenHtmlRendering(context, component);
        } else {
            ResponseWriter out = context.getResponseWriter();
            String text = this.getFormattedValue(context, component, value);
            if (text != null && text.length() != 0) {
                if (RendererUtils.needsEscape(component)) {
                    out.writeText((Object)text, "value");
                } else {
                    out.write(text);
                }
            }
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.endElement("label");
    }

    public static String getForComponentClientId(FacesContext context, UIComponent component) {
        UIComponent base;
        String forId = (String)component.getAttributes().get("for");
        if (forId == null || forId.length() == 0) {
            return null;
        }
        UIComponent forComponent = FacesUtils.getForComponent(context, forId, component);
        if (forComponent != null) {
            return forComponent.getClientId(context);
        }
        for (base = component; base != null && !(base instanceof NamingContainer); base = base.getParent()) {
        }
        if (base != null) {
            return base.getClientId(context) + ':' + forId;
        }
        return null;
    }

    public String getToolBarItemAddScript(FacesContext context, UIComponent item, String jsvar) {
        Formatter fmt = new Formatter();
        fmt.format("%s.addElement(%s);", jsvar, this.getToolBarItemAddElement(context, item));
        return fmt.toString();
    }

    public String getToolBarItemAddElement(FacesContext context, UIComponent item) {
        return "Ext.get('" + item.getClientId(context) + "')";
    }

    public String getToolBarItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        try {
            this.encodeBegin(context, component);
            this.encodeChildren(context, component);
            this.encodeEnd(context, component);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public boolean ignoreChildren() {
        return true;
    }
}

