/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.UISelectRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuRenderer
extends UISelectRenderer {
    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        List<SelectItem> items = this.getSelectItems(context, component);
        this.renderMenu(context, component, items);
    }

    public void renderMenu(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        Integer size;
        ResponseWriter out = context.getResponseWriter();
        out.startElement("select", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        out.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        if (component instanceof UISelectMany) {
            out.writeAttribute("multiple", (Object)Boolean.TRUE, "multiple");
        }
        if ((size = this.getSizeAttribute(context, component)) != null && size != Integer.MIN_VALUE) {
            out.writeAttribute("size", (Object)size, "size");
        }
        RendererUtils.renderPassThruAttributes(out, component, "size");
        out.writeText((Object)"\n", null);
        this.renderOptions(context, component, items);
        out.endElement("select");
    }

    protected void renderOptions(FacesContext context, UIComponent component, List<SelectItem> items) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        for (SelectItem item : items) {
            if (item instanceof SelectItemGroup) {
                SelectItem[] groupItems = ((SelectItemGroup)item).getSelectItems();
                out.startElement("optgroup", component);
                out.writeAttribute("label", (Object)item.getLabel(), "label");
                for (int i = 0; i < groupItems.length; ++i) {
                    this.renderOption(context, component, groupItems[i]);
                }
                out.endElement("optgroup");
                continue;
            }
            this.renderOption(context, component, item);
        }
    }

    protected void renderOption(FacesContext context, UIComponent component, SelectItem item) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String itemValueStr = this.getFormattedValue(context, component, item.getValue());
        String labelClass = null;
        out.startElement("option", component);
        out.writeAttribute("value", (Object)itemValueStr, "value");
        if (this.isSelected(context, component, item.getValue(), itemValueStr)) {
            out.writeAttribute("selected", (Object)Boolean.TRUE, "selected");
        }
        if (!RendererUtils.isDisabled(component) && item.isDisabled()) {
            out.writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
        }
        if ((labelClass = item.isDisabled() ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass")) != null) {
            out.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        out.writeText((Object)item.getLabel(), "label");
        out.endElement("option");
        out.writeText((Object)"\n", null);
    }

    protected Integer getSizeAttribute(FacesContext context, UIComponent component) {
        Integer size = (Integer)component.getAttributes().get("size");
        if (size == null || size == Integer.MIN_VALUE) {
            size = 1;
        }
        return size;
    }
}

