/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.common.RendererUtils;

public class MessagesRenderer
extends HtmlBasicRendererBase {
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        Iterator messageIter = ((UIMessages)component).isGlobalOnly() ? context.getMessages(null) : context.getMessages();
        if (!messageIter.hasNext()) {
            return;
        }
        boolean showSummary = ((UIMessages)component).isShowSummary();
        boolean showDetail = ((UIMessages)component).isShowDetail();
        Object tooltipVal = component.getAttributes().get("tooltip");
        boolean tooltip = false;
        if (tooltipVal instanceof Boolean) {
            tooltip = (Boolean)tooltipVal;
        }
        String layout = (String)component.getAttributes().get("layout");
        boolean tableLayout = "table".equals(layout);
        ResponseWriter out = context.getResponseWriter();
        out.startElement(tableLayout ? "table" : "ul", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        RendererUtils.renderPassThruAttributes(out, component);
        while (messageIter.hasNext()) {
            FacesMessage message = (FacesMessage)messageIter.next();
            String summary = message.getSummary();
            String detail = message.getDetail();
            if (summary == null) {
                summary = "";
            }
            if (detail == null) {
                detail = "";
            }
            String title = null;
            if (showSummary && showDetail && tooltip) {
                title = summary;
            }
            String messageClass = "x-error-message";
            String style = null;
            String styleClass = null;
            if (message.getSeverity() == FacesMessage.SEVERITY_INFO) {
                style = (String)component.getAttributes().get("infoStyle");
                styleClass = (String)component.getAttributes().get("infoClass");
                messageClass = "x-info-message";
            } else if (message.getSeverity() == FacesMessage.SEVERITY_WARN) {
                style = (String)component.getAttributes().get("warnStyle");
                styleClass = (String)component.getAttributes().get("warnClass");
                messageClass = "x-warn-message";
            } else if (message.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                style = (String)component.getAttributes().get("errorStyle");
                styleClass = (String)component.getAttributes().get("errorClass");
                messageClass = "x-error-message";
            } else if (message.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                style = (String)component.getAttributes().get("fatalStyle");
                styleClass = (String)component.getAttributes().get("fatalClass");
                messageClass = "x-fatal-message";
            }
            if (styleClass == null) {
                styleClass = messageClass;
            }
            if (tableLayout) {
                out.startElement("tr", component);
                out.startElement("td", component);
            } else {
                out.startElement("li", component);
            }
            if (style != null) {
                out.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                out.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            if (title != null) {
                out.writeAttribute("title", (Object)title, "title");
            }
            if (showSummary) {
                out.writeText((Object)summary, null);
                if (showDetail) {
                    out.writeText((Object)" ", null);
                }
            }
            if (showDetail) {
                out.writeText((Object)detail, null);
            }
            if (tableLayout) {
                out.endElement("td");
                out.endElement("tr");
                continue;
            }
            out.endElement("li");
        }
        out.endElement(tableLayout ? "table" : "ul");
    }
}

