/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.html.UIInputRenderer;
import org.operamasks.faces.render.resource.Aliases;

public class TextRenderer
extends UIInputRenderer
implements ToolBarItemRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (component instanceof UIInput) {
            super.decode(context, component);
        }
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIInput) {
            this.encodeInputBegin(context, component);
        } else {
            this.encodeOutputBegin(context, component);
        }
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIInput) {
            this.encodeInputText(context, component);
        } else {
            this.encodeOutputText(context, component);
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIInput) {
            this.encodeInputEnd(context, component);
        } else {
            this.encodeOutputEnd(context, component);
        }
    }

    protected void encodeInputBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String currentValue = this.getCurrentValue(context, component);
        out.startElement("input", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        String type = "text";
        out.writeAttribute("type", (Object)type, null);
        out.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String autocomplete = (String)component.getAttributes().get("autocomplete");
        if (autocomplete != null && "off".equals(autocomplete)) {
            out.writeAttribute("autocomplete", (Object)"off", "autocomplete");
        }
        out.writeAttribute("value", (Object)currentValue, "value");
        RendererUtils.renderPassThruAttributes(out, component);
    }

    protected void encodeInputText(FacesContext context, UIComponent component) throws IOException {
    }

    protected void encodeInputEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("input");
    }

    protected void encodeOutputBegin(FacesContext context, UIComponent component) throws IOException {
        if (RendererUtils.shouldWriteIdAttribute(context, component) || RendererUtils.hasPassThruAttributes(component)) {
            ResponseWriter out = context.getResponseWriter();
            out.startElement("span", component);
            RendererUtils.writeIdAttributeIfNecessary(context, out, component);
            RendererUtils.renderPassThruAttributes(out, component);
        }
    }

    protected void encodeOutputText(FacesContext context, UIComponent component) throws IOException {
        Object value = this.getValue(component);
        if (value == null) {
            super.__invokeChildrenHtmlRendering(context, component);
        } else {
            ResponseWriter out = context.getResponseWriter();
            String text = this.getFormattedValue(context, component, value);
            if (text != null && text.length() != 0) {
                if (RendererUtils.needsEscape(component)) {
                    out.writeText((Object)text, "value");
                } else {
                    out.write(text);
                }
            }
        }
    }

    protected void encodeOutputEnd(FacesContext context, UIComponent component) throws IOException {
        if (RendererUtils.shouldWriteIdAttribute(context, component) || RendererUtils.hasPassThruAttributes(component)) {
            ResponseWriter out = context.getResponseWriter();
            out.endElement("span");
        }
    }

    public String getToolBarItemAddScript(FacesContext context, UIComponent item, String jsvar) {
        Formatter fmt = new Formatter();
        fmt.format("%s.add(%s);", jsvar, this.getToolBarItemAddElement(context, item));
        return fmt.toString();
    }

    public String getToolBarItemAddElement(FacesContext context, UIComponent item) {
        return Aliases.getVar(FacesUtils.getJsvar(context, item));
    }

    public String getToolBarItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        String jsvar = FacesUtils.getJsvar(context, component);
        Aliases alias = Aliases.getInstance(context);
        return String.format("%s%s=new %s('%s');", RendererUtils.getJsvarAliasDef(jsvar, alias), jsvar, alias.alias("Ext.Toolbar.TextItem"), component.getAttributes().get("value"));
    }

    public boolean ignoreChildren() {
        return true;
    }
}

