/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.UIOutputRenderer;

public abstract class UIInputRenderer
extends UIOutputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(clientId);
        this.setSubmittedValue(component, newValue);
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        return super.getCurrentValue(context, component);
    }

    public void setSubmittedValue(UIComponent component, Object newValue) {
        if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setSubmittedValue(newValue);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return RendererUtils.getConvertedValue(context, component, submittedValue);
    }
}

