/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.operamasks.faces.debug.Debug;
import org.operamasks.faces.debug.DebugMode;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.Repainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aliases {
    private static final String REQUEST_ALIAS_KEY = "om.REQUEST_ALIAS";
    public static final int IGNORE_ALIAS_MIN_LENGTH = 8;
    private static final String VAR_CHARS = "_$0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private Logger log = Logger.getLogger("org.operamasks.alias");
    private Map<String, String> classAliasMap = new HashMap<String, String>();
    private List<Integer> cliassAliasVarIdx = new ArrayList<Integer>();
    private Map<String, String> varMap = new HashMap<String, String>();
    private List<Integer> varNameIdx = new ArrayList<Integer>();
    private Map<String, List<String>> configMap = new HashMap<String, List<String>>();
    private List<Integer> configNameIdx = new ArrayList<Integer>();

    private Aliases() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Aliases getInstance(FacesContext context) {
        Map reqMap = context.getExternalContext().getRequestMap();
        Aliases instance = (Aliases)reqMap.get(REQUEST_ALIAS_KEY);
        if (instance != null) return instance;
        Class<Aliases> clazz = Aliases.class;
        synchronized (Aliases.class) {
            instance = (Aliases)reqMap.get(REQUEST_ALIAS_KEY);
            if (instance != null) return instance;
            instance = new Aliases();
            reqMap.put(REQUEST_ALIAS_KEY, instance);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public static Aliases getInstance() {
        return Aliases.getInstance(FacesContext.getCurrentInstance());
    }

    public static boolean isDisabled() {
        FacesContext context = FacesContext.getCurrentInstance();
        return Aliases.isDisabled(context);
    }

    public static boolean isDisabled(FacesContext context) {
        String paramFlag = (String)context.getExternalContext().getRequestParameterMap().get("om.alias");
        boolean disabled = paramFlag != null ? "false".equalsIgnoreCase(paramFlag) : Debug.isEnabled(context, DebugMode.DISABLE_ALIAS);
        return disabled || FacesUtils.isAjaxResponse(context) || Repainter.isRepainting(context);
    }

    public static String getAlias(String content) {
        return Aliases.getInstance().alias(content);
    }

    public static String getVar(String varName) {
        return Aliases.getInstance().var(varName);
    }

    public static ConfigBuilder getConfigBuilder(String key) {
        return Aliases.getInstance().configBuilder(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String alias(String content) {
        if (content == null) {
            throw new IllegalArgumentException("arguments cannot be null.");
        }
        String alias = this.classAliasMap.get(content);
        if (alias == null) {
            Aliases aliases = this;
            synchronized (aliases) {
                alias = this.classAliasMap.get(content);
                if (alias == null) {
                    alias = "om$" + Aliases.getVarAlias(this.cliassAliasVarIdx);
                }
                this.classAliasMap.put(content, alias);
            }
        }
        return Aliases.isDisabled() ? content : alias;
    }

    String encodeAliasDefinition(FacesContext context) {
        if (Aliases.isDisabled(context)) {
            return "";
        }
        Set<String> reqAlias = this.classAliasMap.keySet();
        StringBuilder buf = new StringBuilder();
        for (String content : reqAlias) {
            String alias = this.classAliasMap.get(content);
            if (alias == null) continue;
            buf.append(alias).append("=").append(content).append(";");
        }
        if (buf.length() > 0) {
            buf.append("\n");
        }
        return buf.toString();
    }

    String encodeConfigBuilderDefinition(FacesContext context) {
        if (Aliases.isDisabled(context)) {
            return "";
        }
        Set<String> keys = this.configMap.keySet();
        StringBuilder buf = new StringBuilder();
        for (String key : keys) {
            List<String> registered = this.configMap.get(key);
            assert (registered != null);
            String alias = registered.get(0);
            StringBuilder configs = new StringBuilder("[");
            for (int i = 1; i < registered.size(); ++i) {
                configs.append('\'').append(registered.get(i)).append("',");
            }
            if (configs.charAt(configs.length() - 1) == ',') {
                configs.setLength(configs.length() - 1);
            }
            configs.append("]");
            buf.append(alias).append("=OM.CB(").append(configs.toString()).append(");");
        }
        if (buf.length() > 0) {
            buf.append("\n");
        }
        return buf.toString();
    }

    public String var(String varName) {
        if (Aliases.isDisabled() || varName.length() < 8) {
            return varName;
        }
        Map<String, String> temp = this.varMap;
        String alias = temp.get(varName);
        if (alias == null) {
            alias = "_t$" + Aliases.getVarAlias(this.varNameIdx);
            temp.put(varName, alias);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("assigned alias " + alias + " for " + varName);
            }
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(String key) {
        if (this.configMap.containsKey(key)) {
            return;
        }
        Aliases aliases = this;
        synchronized (aliases) {
            if (this.configMap.containsKey(key)) {
                return;
            }
            ArrayList<String> configList = new ArrayList<String>();
            this.configMap.put(key, configList);
            configList.add(0, "oc$" + Aliases.getVarAlias(this.configNameIdx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String configProperty(String key, String name) {
        String result;
        int p;
        if (Aliases.isDisabled()) {
            return name;
        }
        List<String> registered = this.configMap.get(key);
        if (registered == null) {
            throw new IllegalArgumentException("Config key [" + key + "] not found");
        }
        for (p = 1; p < registered.size() && !registered.get(p).equals(name); ++p) {
        }
        if (p < registered.size()) {
            result = String.valueOf(p - 1);
        } else {
            List<String> list = registered;
            synchronized (list) {
                for (p = 1; p < registered.size() && !registered.get(p).equals(name); ++p) {
                }
                if (p < registered.size()) {
                    result = String.valueOf(p - 1);
                } else {
                    registered.add(name);
                    result = String.valueOf(registered.size() - 2);
                }
            }
        }
        return result;
    }

    public String configName(String key) {
        if (Aliases.isDisabled()) {
            return "";
        }
        List<String> registered = this.configMap.get(key);
        if (registered == null) {
            throw new IllegalArgumentException("Config key [" + key + "] not found");
        }
        return registered.get(0) + "(";
    }

    public String configEnd() {
        return Aliases.isDisabled() ? "" : ")";
    }

    public ConfigBuilder configBuilder(String key) {
        this.registerConfig(key);
        return new ConfigBuilder(key);
    }

    private static String getVarAlias(List<Integer> nameIdx) {
        block4: {
            int len = nameIdx.size();
            if (len == 0) {
                nameIdx.add(0);
            } else {
                int v;
                int pos = 0;
                while ((v = nameIdx.get(pos).intValue()) >= VAR_CHARS.length() - 1) {
                    nameIdx.set(pos, 0);
                    if (++pos != len) continue;
                    nameIdx.add(0);
                    break block4;
                }
                nameIdx.set(pos, v + 1);
            }
        }
        StringBuilder var = new StringBuilder();
        for (Integer p : nameIdx) {
            var.append(VAR_CHARS.charAt(p));
        }
        return var.toString();
    }

    public class ConfigBuilder {
        private String key;

        public ConfigBuilder(String key) {
            this.key = key;
        }

        public String start() {
            return Aliases.this.configName(this.key);
        }

        public String prop(String name) {
            return Aliases.this.configProperty(this.key, name);
        }

        public String end() {
            return Aliases.this.configEnd();
        }
    }
}

