/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.debug.Debug;
import org.operamasks.faces.debug.DebugMode;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResourceManager;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.resource.ResourceMode;
import org.operamasks.faces.render.resource.SkinDescriptor;
import org.operamasks.faces.render.resource.SkinManager;
import org.operamasks.faces.util.Repainter;
import org.operamasks.faces.util.StringUtils;
import org.operamasks.faces.util.jsformatter.JSFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentResource
extends AbstractResource
implements Cloneable {
    public static final String RESOURCE_ID = "urn:yui-ext";
    public static final String EXT_BASE_JS = "/ext/ext-base.js";
    public static final String EXT_CORE_JS = "/ext/ext-core.js";
    public static final String EXT_ALL_JS = "/ext/ext-all.js";
    public static final String EXT_LANG_JS = "/ext/locale/ext-lang.js";
    public static final String EXT_LANG_DEBUG_JS = "/ext/locale/ext-lang-debug.js";
    private static final String BLANK_IMAGE_URL = "/ext/s.gif";
    private Map<String, String> debugScriptsCache;
    private List<String> js_dependencies = new ArrayList<String>();
    private List<String> css_dependencies = new ArrayList<String>();
    private boolean beginEncoded = false;
    private StringBuffer initScript = new StringBuffer();
    private List<String> variables = new ArrayList<String>();
    private List<String> tempvars = new ArrayList<String>();
    private int maxTempVar = 0;
    private int fragmentLevel = 0;
    private static final String TEMP_VAR_PREFIX = "_$";
    private static final String JS_SUFFIX = ".js";
    static final String DCSS_SUFFIX = ".dcss";
    public static final String MERGE_JS = "__MERGE_JS";
    public static final String MERGE_CSS = "__MERGE_CSS";
    private static final String BUTIFYJS_KEY = "om.beautifyJS";
    private static String KEY_SHOW_CLIENT_EXCEPTION = "org.operamasks.faces.SHOWCLIENTEXCEPTION";
    private static String KEY_CATCH_ALL_EXCEPTION = "om.catchJSException";

    private ComponentResource() {
        super(RESOURCE_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addJSPackageDependency(String name) {
        Map<String, String[]> js_pkg2uris = ComponentResourceManager.getInstance(FacesContext.getCurrentInstance()).getJs_pkg2uris();
        String[] uris = js_pkg2uris.get(name);
        if (uris == null) {
            throw new IllegalArgumentException("Unknown package: " + name);
        }
        if (!this.beginEncoded) {
            for (String uri : uris) {
                if (this.js_dependencies.contains(uri)) continue;
                this.js_dependencies.add(uri);
            }
            return;
        } else {
            ArrayList<String> deps = new ArrayList<String>();
            for (String uri : uris) {
                if (this.js_dependencies.contains(uri)) continue;
                deps.add(uri);
            }
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                ResourceManager rm = ResourceManager.getInstance(context);
                if (this.js_dependencies.contains(EXT_ALL_JS)) return;
                if (deps.contains(EXT_ALL_JS)) {
                    this.encodeAllScript(context, rm);
                    this.js_dependencies.clear();
                    this.js_dependencies.add(EXT_ALL_JS);
                    return;
                }
                if (this.js_dependencies.isEmpty()) {
                    this.encodeScriptByUri(context, EXT_CORE_JS);
                }
                for (String uri : deps) {
                    this.encodeScriptByUri(context, uri);
                    this.js_dependencies.add(uri);
                }
                return;
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    public void addCSSPackageDependency(String name) {
        Map<String, String[]> css_pkg2uris = ComponentResourceManager.getInstance(FacesContext.getCurrentInstance()).getCss_pkg2uris();
        String[] uris = css_pkg2uris.get(name);
        if (uris == null) {
            throw new IllegalArgumentException("Unknown package: " + name);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        for (String uri : uris) {
            String skin = SkinManager.getCurrentSkin(context);
            if (this.css_dependencies.contains(uri = uri.replace("${skin}", skin))) continue;
            this.css_dependencies.add(uri);
        }
    }

    public void addJSPackageDependency(String name, boolean isPostback) {
        if (isPostback) {
            this.beginEncoded = true;
        }
        this.addJSPackageDependency(name);
    }

    public void addVariable(String var) {
        this.variables.add(var);
    }

    public String allocVariable(UIComponent component) {
        FacesContext context;
        ResponseWriter resp;
        String var = (String)component.getAttributes().get("jsvar");
        if (var == null && ((resp = (context = FacesContext.getCurrentInstance()).getResponseWriter()) instanceof AjaxHtmlResponseWriter || resp instanceof AjaxResponseWriter || resp instanceof HtmlResponseWriter)) {
            var = FacesUtils.getJsvar(context, component);
        }
        if (var != null) {
            this.addVariable(var);
        } else {
            var = this.allocTempVariable();
        }
        return var;
    }

    public String allocTempVariable() {
        if (!this.tempvars.isEmpty()) {
            return this.tempvars.remove(0);
        }
        return TEMP_VAR_PREFIX + this.maxTempVar++;
    }

    public boolean isTempVariable(String var) {
        return var.startsWith(TEMP_VAR_PREFIX);
    }

    public void releaseVariable(String var) {
        if (var.startsWith(TEMP_VAR_PREFIX)) {
            this.tempvars.add(var);
        }
    }

    private void increaseFragmentLevel() {
        ++this.fragmentLevel;
    }

    private void decreaseFragmentLevel() {
        --this.fragmentLevel;
    }

    public void resetFragmentLevel() {
        this.fragmentLevel = 0;
    }

    public void addInitScript(String script) {
        if (this.fragmentLevel == 0 && script.length() > 0 && ComponentResource.getCatchAllException().booleanValue()) {
            this.initScript.append("\nOM.E(function(){").append(script).append("});");
        } else {
            this.initScript.append(script);
        }
    }

    public void addInitScriptBegin(String script) {
        if (this.fragmentLevel == 0 && ComponentResource.getCatchAllException().booleanValue()) {
            this.initScript.append("\nOM.E(function(){").append(script);
        } else {
            this.initScript.append(script);
        }
        this.increaseFragmentLevel();
    }

    public void addInitScriptEnd(String script) {
        this.decreaseFragmentLevel();
        if (this.fragmentLevel == 0 && ComponentResource.getCatchAllException().booleanValue()) {
            this.initScript.append(script).append("});");
        } else {
            this.initScript.append(script);
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        boolean mergeCss;
        String cssFile;
        SkinDescriptor skinDesc;
        this.beginEncoded = true;
        ResourceManager rm = ResourceManager.getInstance(context);
        String skin = SkinManager.getCurrentSkin(context);
        ResponseWriter out = context.getResponseWriter();
        if (this.js_dependencies.contains(EXT_ALL_JS)) {
            this.encodeScriptByUri(context, EXT_BASE_JS);
            this.encodeAllScript(context, rm);
        } else {
            boolean mergeJs = this.getMergeJs(context);
            if (mergeJs) {
                this.encodeSingleJsByUris(context, this.js_dependencies);
            } else {
                for (String dep : this.js_dependencies) {
                    this.encodeScriptByUri(context, dep);
                }
            }
        }
        if (this.js_dependencies.contains(EXT_BASE_JS) || this.js_dependencies.contains(EXT_ALL_JS)) {
            out.startElement("script", null);
            out.writeAttribute("type", (Object)"text/javascript", null);
            out.write("Ext.BLANK_IMAGE_URL=\"" + rm.getResourceURL(BLANK_IMAGE_URL) + "\";");
            out.endElement("script");
            out.write("\n");
        }
        if ((skinDesc = SkinManager.getInstance(context).getSkin(skin)) != null && (cssFile = skinDesc.getFile()) != null && cssFile.length() > 0) {
            this.css_dependencies.add(rm.getSkinResourceLocation(skinDesc));
        }
        if (mergeCss = this.getMergeCss(context)) {
            this.encodeSingleCssByUris(context, this.css_dependencies, "x-skin");
        } else {
            for (String dep : this.css_dependencies) {
                ComponentResource.encodeCss(context, dep, "x-skin");
            }
        }
        if (this.js_dependencies.contains(EXT_BASE_JS) || this.js_dependencies.contains(EXT_ALL_JS)) {
            ComponentResource.encodeLocaleResource(context, rm);
        }
    }

    private boolean getMergeJs(FacesContext context) {
        Object pageSetting = context.getExternalContext().getRequestMap().get(MERGE_JS);
        if (pageSetting != null) {
            return (Boolean)pageSetting;
        }
        Object globalSetting = ResourceMode.getValue(context, ResourceMode.MERGE_JS);
        if (globalSetting != null) {
            return (Boolean)globalSetting;
        }
        return false;
    }

    private boolean getMergeCss(FacesContext context) {
        Object pageSetting = context.getExternalContext().getRequestMap().get(MERGE_CSS);
        if (pageSetting != null) {
            return (Boolean)pageSetting;
        }
        Object globalSetting = ResourceMode.getValue(context, ResourceMode.MERGE_CSS);
        if (globalSetting != null) {
            return (Boolean)globalSetting;
        }
        return false;
    }

    public static void encodeLocaleResource(FacesContext context, ResourceManager rm) throws IOException {
        Locale locale = context.getViewRoot().getLocale();
        if (Debug.isEnabled(DebugMode.UNCOMPRESSED_JS)) {
            ComponentResource.encodeScript(context, rm.getResourceURL(EXT_LANG_DEBUG_JS, locale));
        } else {
            ComponentResource.encodeScript(context, rm.getResourceURL(EXT_LANG_JS, locale));
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        if (this.variables.size() != 0 || this.initScript.length() != 0) {
            ResponseWriter out = context.getResponseWriter();
            if (out instanceof AjaxResponseWriter) {
                String script = this.encodeAjaxInitScript();
                if (Repainter.isRepainting(context)) {
                    ((AjaxResponseWriter)out).writeScriptBlock(script);
                } else {
                    ((AjaxResponseWriter)out).writeActionScript(script);
                }
            } else {
                String script = this.encodeInitScript(context);
                out.write(script);
            }
        }
    }

    private String encodeInitScript(FacesContext context) {
        String paramFlag;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("if(Ext && Ext.QuickTips)Ext.QuickTips.init();\n");
        if (this.variables.size() != 0) {
            buf.append("var ");
            for (i = 0; i < this.variables.size(); ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(this.variables.get(i));
            }
            buf.append(";\n");
        }
        if (this.initScript.length() != 0) {
            buf.append("Ext.onReady(function(){\n");
            buf.append("document.body.insertBefore(document.createElement('style'), document.body.firstChild );\n");
            if (this.maxTempVar > 0) {
                buf.append("var ");
                for (i = 0; i < this.maxTempVar; ++i) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    buf.append(TEMP_VAR_PREFIX).append(i);
                }
                buf.append(";\n");
            }
            buf.append(Aliases.getInstance(context).encodeAliasDefinition(context));
            buf.append(Aliases.getInstance(context).encodeConfigBuilderDefinition(context));
            buf.append(this.initScript);
            buf.append("\n});\n");
        }
        if ((paramFlag = (String)context.getExternalContext().getRequestParameterMap().get(BUTIFYJS_KEY)) != null ? !"false".equalsIgnoreCase(paramFlag) : Debug.isEnabled(DebugMode.BEAUTIFY_JS)) {
            JSFormatter jsFmt = new JSFormatter();
            String script = jsFmt.format(buf.toString());
            buf = new StringBuilder(script);
        }
        buf.insert(0, "<script type=\"text/javascript\">\n<!--\n");
        buf.append("//-->\n</script>\n");
        return buf.toString();
    }

    private String encodeAjaxInitScript() {
        StringBuilder buf = new StringBuilder();
        if (this.initScript.length() != 0) {
            buf.append("(function(){");
            if (this.variables != null && this.variables.size() > 0) {
                for (String var : this.variables) {
                    buf.append("\nwindow['" + var + "'] = null;");
                }
            }
            if (this.maxTempVar > 0) {
                buf.append("var ");
                for (int i = 0; i < this.maxTempVar; ++i) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    buf.append(TEMP_VAR_PREFIX).append(i);
                }
                buf.append(";");
            }
            buf.append(this.initScript);
            buf.append("})();");
        }
        return buf.toString();
    }

    public static ComponentResource getResourceInstance(ResourceManager rm) {
        ComponentResource resource = (ComponentResource)rm.getRegisteredResource(RESOURCE_ID);
        if (resource == null) {
            resource = new ComponentResource();
            rm.registerResource(resource);
        }
        return resource;
    }

    public static ComponentResource registerJS(ResourceManager rm, String ... dependencies) {
        ComponentResource resource = ComponentResource.getResourceInstance(rm);
        if (dependencies != null) {
            for (String pkg : dependencies) {
                resource.addJSPackageDependency(pkg);
            }
        }
        return resource;
    }

    public static ComponentResource registerCSS(ResourceManager rm, String ... dependencies) {
        ComponentResource resource = (ComponentResource)rm.getRegisteredResource(RESOURCE_ID);
        if (resource == null) {
            resource = new ComponentResource();
            rm.registerResource(resource);
        }
        if (dependencies != null) {
            for (String pkg : dependencies) {
                resource.addCSSPackageDependency(pkg);
            }
        }
        return resource;
    }

    private void encodeSingleJsByUris(FacesContext context, List<String> jsDependencies) throws IOException {
        if (jsDependencies.size() > 0) {
            ArrayList<String> encodedUri = new ArrayList<String>();
            for (String uri : jsDependencies) {
                if (Debug.isEnabled(DebugMode.UNCOMPRESSED_JS) && uri.endsWith(JS_SUFFIX)) {
                    String debugScriptUri;
                    if (this.debugScriptsCache == null) {
                        this.debugScriptsCache = new HashMap<String, String>();
                    }
                    if ((debugScriptUri = this.debugScriptsCache.get(uri)) == null) {
                        int dotIndex = uri.lastIndexOf(".");
                        debugScriptUri = uri.substring(0, dotIndex) + "-debug" + uri.substring(dotIndex);
                        if (ComponentResource.class.getResource("/META-INF/resource" + debugScriptUri) == null) {
                            debugScriptUri = uri;
                        }
                        this.debugScriptsCache.put(uri, debugScriptUri);
                    }
                    uri = debugScriptUri;
                }
                if (!uri.endsWith(JS_SUFFIX)) continue;
                encodedUri.add(uri.replace("/", "|").replace(JS_SUFFIX, ""));
            }
            String singleJsPath = "/_$js/" + StringUtils.join(encodedUri, ";");
            ComponentResource.encodeScript(context, ResourceManager.getInstance(context).getResourceURL(singleJsPath));
        }
    }

    private void encodeScriptByUri(FacesContext context, String uri) throws IOException {
        if (Debug.isEnabled(DebugMode.UNCOMPRESSED_JS) && uri.endsWith(JS_SUFFIX)) {
            String debugScriptUri;
            if (this.debugScriptsCache == null) {
                this.debugScriptsCache = new HashMap<String, String>();
            }
            if ((debugScriptUri = this.debugScriptsCache.get(uri)) == null) {
                int dotIndex = uri.lastIndexOf(".");
                debugScriptUri = uri.substring(0, dotIndex) + "-debug" + uri.substring(dotIndex);
                if (ComponentResource.class.getResource("/META-INF/resource" + debugScriptUri) == null) {
                    debugScriptUri = uri;
                }
                this.debugScriptsCache.put(uri, debugScriptUri);
            }
            uri = debugScriptUri;
        }
        ComponentResource.encodeScript(context, ResourceManager.getInstance(context).getResourceURL(uri));
    }

    private static void encodeScript(FacesContext context, String url) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (out instanceof AjaxResponseWriter) {
            ((AjaxResponseWriter)out).writeScriptBlock("OM.ajax.loadScript('" + url + "');\n");
        } else {
            out.startElement("script", null);
            out.writeAttribute("type", (Object)"text/javascript", null);
            out.writeAttribute("src", (Object)url, null);
            out.writeAttribute("charset", (Object)"UTF-8", null);
            out.endElement("script");
            out.write("\n");
        }
    }

    private void encodeAllScript(FacesContext context, ResourceManager rm) throws IOException {
        Map<String, String[]> js_pkg2uris = ComponentResourceManager.getInstance(FacesContext.getCurrentInstance()).getJs_pkg2uris();
        for (String uri : js_pkg2uris.get("All")) {
            this.encodeScriptByUri(context, uri);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeSingleCssByUris(FacesContext context, List<String> cssDependencies, String cls) throws IOException {
        LinkedHashMap<String, ArrayList<String>> cssDirs = new LinkedHashMap<String, ArrayList<String>>();
        for (String string : cssDependencies) {
            void var6_6;
            if (!string.startsWith("/")) {
                String string2 = "/" + string;
            }
            int pos = var6_6.lastIndexOf("/");
            String dir = var6_6.substring(0, pos + 1);
            String cssFileName = var6_6.substring(pos + 1).replace(".css", "");
            ArrayList<String> cssFileNames = (ArrayList<String>)cssDirs.get(dir);
            if (!cssDirs.containsKey(dir)) {
                cssFileNames = new ArrayList<String>();
                cssDirs.put(dir, cssFileNames);
            }
            cssFileNames.add(cssFileName);
        }
        for (Map.Entry entry : cssDirs.entrySet()) {
            String dir = (String)entry.getKey();
            List cssFileNames = (List)entry.getValue();
            String singleCssPath = dir + StringUtils.join((Collection)cssFileNames, ";") + DCSS_SUFFIX;
            ResponseWriter out = context.getResponseWriter();
            if (out instanceof AjaxResponseWriter) {
                ((AjaxResponseWriter)out).writeScriptBlock("OM.ajax.loadStylesheet('" + ResourceManager.getInstance(context).getResourceURL(singleCssPath) + "',null," + (cls == null ? "null" : "'" + cls + "'") + ");\n");
                continue;
            }
            out.startElement("link", null);
            if (cls != null) {
                out.writeAttribute("class", (Object)cls, null);
            }
            out.writeAttribute("rel", (Object)"stylesheet", null);
            out.writeAttribute("type", (Object)"text/css", null);
            out.writeAttribute("href", (Object)ResourceManager.getInstance(context).getResourceURL(singleCssPath), null);
            out.endElement("link");
            out.write("\n");
        }
    }

    private static void encodeCss(FacesContext context, String url, String cls) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (out instanceof AjaxResponseWriter) {
            ((AjaxResponseWriter)out).writeScriptBlock("OM.ajax.loadStylesheet('" + ResourceManager.getInstance(context).getResourceURL(url) + "',null," + (cls == null ? "null" : "'" + cls + "'") + ");\n");
        } else {
            out.startElement("link", null);
            if (cls != null) {
                out.writeAttribute("class", (Object)cls, null);
            }
            out.writeAttribute("rel", (Object)"stylesheet", null);
            out.writeAttribute("type", (Object)"text/css", null);
            out.writeAttribute("href", (Object)ResourceManager.getInstance(context).getResourceURL(url), null);
            out.endElement("link");
            out.write("\n");
        }
    }

    public static void setShowClientException(Boolean show) {
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(KEY_SHOW_CLIENT_EXCEPTION, show);
    }

    public static Boolean getShowClientException() {
        Boolean show = (Boolean)FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().get(KEY_SHOW_CLIENT_EXCEPTION);
        if (show == null) {
            show = Boolean.TRUE;
        }
        return show;
    }

    public static void setCatchAllException(Boolean catchAll) {
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(KEY_CATCH_ALL_EXCEPTION, catchAll);
    }

    public static Boolean getCatchAllException() {
        ExternalContext ectxt = FacesContext.getCurrentInstance().getExternalContext();
        String paramFlag = (String)ectxt.getRequestParameterMap().get(KEY_CATCH_ALL_EXCEPTION);
        return paramFlag != null ? !"false".equalsIgnoreCase(paramFlag) : !Boolean.FALSE.equals(ectxt.getApplicationMap().get(KEY_CATCH_ALL_EXCEPTION));
    }
}

