/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.render.resource.ResourcePackages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentResourceManager {
    private Map<String, String[]> js_pkg2uris;
    private Map<String, String[]> css_pkg2uris;
    private static final String WEB_INF_RESOURCE_DEPENDENCES_FILE = "/WEB-INF/resource-dependences.xml";
    private static final String RESOURCE_DEPENDENCES = "META-INF/resource/resource-dependences.xml";

    public static ComponentResourceManager getInstance(FacesContext context) {
        ApplicationAssociate appAssociate = ApplicationAssociate.getInstance(context);
        return appAssociate.getSingleton(ComponentResourceManager.class);
    }

    public Map<String, String[]> getJs_pkg2uris() {
        return this.js_pkg2uris;
    }

    public Map<String, String[]> getCss_pkg2uris() {
        return this.css_pkg2uris;
    }

    private ComponentResourceManager() {
        try {
            InputStream stream;
            ClassLoader cl = ComponentResourceManager.getClassLoader();
            HashMap<String, ResourcePackages.Package> jsDeps = new HashMap<String, ResourcePackages.Package>();
            HashMap<String, ResourcePackages.Package> cssDeps = new HashMap<String, ResourcePackages.Package>();
            Enumeration<URL> urls = cl.getResources(RESOURCE_DEPENDENCES);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                stream = url.openStream();
                ResourcePackages.load(stream, jsDeps, cssDeps);
                stream.close();
            }
            URL appResource = FacesContext.getCurrentInstance().getExternalContext().getResource(WEB_INF_RESOURCE_DEPENDENCES_FILE);
            if (appResource != null) {
                stream = appResource.openStream();
                ResourcePackages.load(stream, jsDeps, cssDeps);
                stream.close();
            }
            this.js_pkg2uris = ResourcePackages.buildJS(jsDeps);
            this.css_pkg2uris = ResourcePackages.buildCSS(cssDeps);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static ClassLoader getClassLoader() {
        ApplicationAssociate associate = ApplicationAssociate.getInstance();
        if (associate != null) {
            return associate.getClassLoader();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }
}

