/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.resource.ResourceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalResourceService
extends ResourceService {
    private ConcurrentHashMap<String, ResourceInfo> resourcesInfo = new ConcurrentHashMap();
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final String DEFAULT_CHARSET = "UTF-8";

    @Override
    public void service(FacesContext context) throws IOException {
        Object requestObj = context.getExternalContext().getRequest();
        if (!(requestObj instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)requestObj;
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        String uri = request.getRequestURI();
        String locale = request.getQueryString();
        if (locale != null) {
            if (locale.length() > 5 && locale.charAt(5) == '_') {
                locale = locale.substring(0, 5);
            }
            if (locale.length() != 2 && locale.length() != 5 || locale.length() == 5 && locale.charAt(2) != '_') {
                locale = null;
            }
        }
        URL resource = null;
        try {
            ResourceManager rm = ResourceManager.getInstance(context);
            int pos = uri.indexOf("/_global/resource/_$js");
            if (pos != -1) {
                String resource_view_path = uri.substring(0, pos + "/_global/resource".length());
                pos = uri.lastIndexOf("/");
                String singleresourcepath = uri.substring(pos + 1);
                String[] encodedUris = singleresourcepath.split(";");
                ArrayList<URL> urls = new ArrayList<URL>();
                ArrayList<String> uris = new ArrayList<String>();
                for (String encodedUri : encodedUris) {
                    String aUri = encodedUri.replace("|", "/");
                    if (!aUri.startsWith("/")) {
                        aUri = "/" + aUri;
                    }
                    uris.add(resource_view_path + aUri + ".js");
                    urls.add(rm.getLocalResource(resource_view_path + aUri + ".js", locale));
                }
                if (urls.size() > 0) {
                    context.responseComplete();
                    this.sendSingleResource(context, urls, uris, "js");
                }
            } else if (uri.endsWith(".dcss")) {
                pos = uri.lastIndexOf("/");
                String uriDir = uri.substring(0, pos + 1);
                String[] cssFileNames = uri.substring(pos + 1).replace(".dcss", "").split(";");
                ArrayList<URL> urls = new ArrayList<URL>();
                ArrayList<String> uris = new ArrayList<String>();
                for (String cssFileName : cssFileNames) {
                    uris.add(uriDir + cssFileName + ".css");
                    urls.add(rm.getLocalResource(uriDir + cssFileName + ".css", locale));
                }
                if (urls.size() > 0) {
                    context.responseComplete();
                    this.sendSingleResource(context, urls, uris, "css");
                }
            } else {
                String etag;
                ResourceInfo ri = this.resourcesInfo.get(uri);
                if (ri != null && GlobalResourceService.checkModified(ri.lastModified, etag = GlobalResourceService.makeETag(ri), request, response)) {
                    context.responseComplete();
                    return;
                }
                resource = rm.getLocalResource(uri, locale);
                if (resource != null) {
                    context.responseComplete();
                    this.sendResource(context, resource, uri);
                }
            }
        }
        catch (FileNotFoundException ex) {
            context.responseComplete();
            response.sendError(404, ex.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSingleResource(FacesContext context, List<URL> urls, List<String> uris, String resourceType) throws IOException {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        ArrayList<ResourceInfo> ris = new ArrayList<ResourceInfo>();
        for (int i = 0; i < urls.size(); ++i) {
            URL resource = urls.get(i);
            String uri = uris.get(i);
            ResourceInfo ri = this.resourcesInfo.get(uri);
            if (ri == null) {
                URLConnection uc;
                try {
                    uc = resource.openConnection();
                }
                catch (Throwable th) {
                    response.setStatus(412);
                    return;
                }
                ri = new ResourceInfo();
                ri.size = uc.getContentLength();
                ri.lastModified = uc.getLastModified();
                this.resourcesInfo.put(uri, ri);
            }
            ris.add(ri);
        }
        long requestTime = System.currentTimeMillis();
        if (ris.size() > 0) {
            String etag = this.makeETag(ris);
            long lastModified = this.getLastModified(ris);
            if (GlobalResourceService.checkModified(lastModified, etag, request, response)) {
                context.responseComplete();
                return;
            }
            if (GlobalResourceService.checkModified(lastModified, etag, request, response)) {
                return;
            }
            String type = null;
            type = "js".equals(resourceType) ? "text/javascript" : ("css".equals("css") ? "text/css" : DEFAULT_MIME_TYPE);
            type = type + ";charset=UTF-8";
            response.setContentType(type);
            if (lastModified > requestTime) {
                lastModified = requestTime;
            }
            if (lastModified > 0L) {
                response.setDateHeader("Last-Modified", lastModified);
            }
            response.setHeader("Cache-Control", "max-age=8640000");
            InputStream in = null;
            OutputStream out = null;
            try {
                long count = 0L;
                for (URL url : urls) {
                    int n;
                    in = url.openStream();
                    out = response.getOutputStream();
                    byte[] buf = new byte[8192];
                    while ((n = in.read(buf)) != -1) {
                        count += (long)n;
                        out.write(buf, 0, n);
                    }
                    out.write("\n".getBytes(DEFAULT_CHARSET));
                    if (in == null) continue;
                    in.close();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResource(FacesContext context, URL resource, String uri) throws IOException {
        ServletContext sctx = (ServletContext)context.getExternalContext().getContext();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        String filename = resource.getFile();
        ResourceInfo ri = this.resourcesInfo.get(uri);
        if (ri == null) {
            URLConnection uc;
            try {
                uc = resource.openConnection();
            }
            catch (Throwable th) {
                response.setStatus(412);
                return;
            }
            ri = new ResourceInfo();
            ri.size = uc.getContentLength();
            ri.lastModified = uc.getLastModified();
            this.resourcesInfo.put(uri, ri);
        }
        long requestTime = System.currentTimeMillis();
        if (ri != null) {
            String type;
            String etag = GlobalResourceService.makeETag(ri);
            if (GlobalResourceService.checkModified(ri.lastModified, etag, request, response)) {
                return;
            }
            if (filename.endsWith(".gz")) {
                response.setHeader("Content-Encoding", "gzip");
                filename = filename.substring(0, filename.length() - 3);
            }
            if ((type = sctx.getMimeType(filename)) == null) {
                type = DEFAULT_MIME_TYPE;
            }
            type = type + ";charset=UTF-8";
            response.setContentType(type);
            if (ri.lastModified > requestTime) {
                ri.lastModified = requestTime;
            }
            if (ri.lastModified > 0L) {
                response.setDateHeader("Last-Modified", ri.lastModified);
            }
            response.setHeader("Cache-Control", "max-age=8640000");
            InputStream in = null;
            ServletOutputStream out = null;
            try {
                int n;
                in = resource.openStream();
                out = response.getOutputStream();
                byte[] buf = new byte[8192];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static boolean checkModified(long lastModified, String etag, HttpServletRequest request, HttpServletResponse response) {
        String ifNoneMatch;
        String method = request.getMethod();
        boolean isGET = "GET".equals(method) || "HEAD".equals(method);
        long requestTime = System.currentTimeMillis();
        String ifMatch = request.getHeader("If-Match");
        if (ifMatch != null) {
            if (!ifMatch.equals("*") && (etag == null || etag.startsWith("W/") || ifMatch.indexOf(etag) == -1)) {
                response.setStatus(412);
                return true;
            }
        } else {
            long ifUnmodified = request.getDateHeader("If-Unmodified-Since");
            if (ifUnmodified > 0L && (lastModified <= 0L || lastModified > ifUnmodified)) {
                response.setStatus(412);
                return true;
            }
        }
        if ((ifNoneMatch = request.getHeader("If-None-Match")) != null) {
            if (ifNoneMatch.equals("*") || etag != null && ifNoneMatch.indexOf(etag) != -1 && (!etag.startsWith("W/") || isGET && request.getHeader("Range") == null)) {
                response.setStatus(isGET ? 304 : 412);
                return true;
            }
        } else {
            long ifModified;
            try {
                ifModified = request.getDateHeader("If-Modified-Since");
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            if (lastModified > 0L && ifModified >= lastModified && ifModified <= requestTime) {
                response.setStatus(isGET ? 304 : 412);
                return true;
            }
        }
        return false;
    }

    private static String makeETag(ResourceInfo ri) {
        if (ri.size >= 0L && ri.lastModified > 0L) {
            return '\"' + Long.toHexString(ri.size) + '-' + Long.toHexString(ri.lastModified) + '\"';
        }
        return null;
    }

    private String makeETag(List<ResourceInfo> ris) {
        long size = 0L;
        long lastModified = 0L;
        for (ResourceInfo ri : ris) {
            size += ri.size;
            if (ri.lastModified <= lastModified) continue;
            lastModified = ri.lastModified;
        }
        if (size >= 0L && lastModified > 0L) {
            return '\"' + Long.toHexString(size) + '-' + Long.toHexString(lastModified) + '\"';
        }
        return null;
    }

    private long getLastModified(List<ResourceInfo> ris) {
        long lastModified = 0L;
        for (ResourceInfo ri : ris) {
            if (ri.lastModified <= lastModified) continue;
            lastModified = ri.lastModified;
        }
        return lastModified;
    }

    private static class ResourceInfo {
        long size;
        long lastModified;

        private ResourceInfo() {
        }
    }
}

