/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.render.resource.ResourceServiceManager;

public class ResourceServlet
extends HttpServlet {
    private FacesContextFactory facesContextFactory;
    private Lifecycle lifecycle;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        }
        catch (FacesException ex) {
            throw new UnavailableException(ex.getMessage());
        }
        if (this.facesContextFactory == null || this.lifecycle == null) {
            throw new UnavailableException("No faces context available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FacesContext context = this.facesContextFactory.getFacesContext((Object)this.getServletContext(), (Object)request, (Object)response, this.lifecycle);
        try {
            ResourceServiceManager.getInstance(context).service(context);
        }
        finally {
            context.release();
        }
    }
}

