/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinDescriptor {
    private String id;
    private String file;
    private Map<Locale, String> displayNames = new HashMap<Locale, String>();
    private Map<String, String> properties = new HashMap<String, String>();

    SkinDescriptor(String id, String file) {
        this.id = id;
        this.file = file;
    }

    public String getId() {
        return this.id;
    }

    public String getFile() {
        return this.file;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getDisplayName(Locale locale) {
        if (this.displayNames.get(locale) != null) {
            return this.displayNames.get(locale);
        }
        return this.displayNames.get(Locale.ENGLISH);
    }

    public String getDescription() {
        return this.getProperty("description");
    }

    public String getAuthorName() {
        return this.getProperty("authorName");
    }

    public String getAuthorEmail() {
        return this.getProperty("authorEmail");
    }

    public void setDisplayName(Locale locale, String displayName) {
        this.displayNames.put(locale, displayName);
    }
}

