/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.io.IOException;

public class Base64 {
    private static final int BYTES_PER_ATOM = 3;
    private static final int CHARS_PER_ATOM = 4;
    private static final char[] pem_array;
    private static final byte[] pem_convert_array;

    public static String encode(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return "";
        }
        int inputLen = buffer.length;
        int numAtoms = inputLen / 3;
        if (inputLen % 3 != 0) {
            ++numAtoms;
        }
        int outputLen = numAtoms * 4;
        char[] output = new char[outputLen];
        int outOffset = 0;
        int inOffset = 0;
        for (int i = 0; i < numAtoms; ++i) {
            Base64.encodeAtom(output, outOffset, buffer, inOffset, inputLen - inOffset);
            inOffset += 3;
            outOffset += 4;
        }
        return new String(output);
    }

    protected static void encodeAtom(char[] output, int outOffset, byte[] data, int offset, int len) {
        if (len == 1) {
            byte a = data[offset];
            boolean b = false;
            boolean c = false;
            output[outOffset] = pem_array[a >>> 2 & 0x3F];
            output[outOffset + 1] = pem_array[a << 4 & 0x30];
            output[outOffset + 2] = 61;
            output[outOffset + 3] = 61;
        } else if (len == 2) {
            byte a = data[offset];
            byte b = data[offset + 1];
            boolean c = false;
            output[outOffset] = pem_array[a >>> 2 & 0x3F];
            output[outOffset + 1] = pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            output[outOffset + 2] = pem_array[b << 2 & 0x3C];
            output[outOffset + 3] = 61;
        } else {
            byte a = data[offset];
            byte b = data[offset + 1];
            byte c = data[offset + 2];
            output[outOffset] = pem_array[a >>> 2 & 0x3F];
            output[outOffset + 1] = pem_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            output[outOffset + 2] = pem_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
            output[outOffset + 3] = pem_array[c & 0x3F];
        }
    }

    public static byte[] decode(String input) throws IOException {
        return Base64.decode(input.getBytes());
    }

    public static byte[] decode(byte[] input) throws IOException {
        if (input == null || input.length == 0) {
            return new byte[0];
        }
        int inputLen = input.length;
        int numAtoms = inputLen / 4;
        if (inputLen % 4 != 0) {
            throw new IOException("Invalid BASE64 encoded string.");
        }
        int outputLen = numAtoms * 3;
        if (input[inputLen - 1] == 61) {
            --outputLen;
        }
        if (input[inputLen - 2] == 61) {
            --outputLen;
        }
        byte[] output = new byte[outputLen];
        int inOffset = 0;
        int outOffset = 0;
        for (int i = 0; i < numAtoms; ++i) {
            Base64.decodeAtom(output, outOffset, input, inOffset);
            inOffset += 4;
            outOffset += 3;
        }
        return output;
    }

    protected static void decodeAtom(byte[] output, int outOffset, byte[] input, int inOffset) {
        int a = -1;
        int b = -1;
        int c = -1;
        int d = -1;
        int rem = 4;
        if (input[inOffset + 3] == 61) {
            rem = 3;
        }
        if (input[inOffset + 2] == 61) {
            rem = 2;
        }
        switch (rem) {
            default: {
                d = pem_convert_array[input[inOffset + 3] & 0xFF];
            }
            case 3: {
                c = pem_convert_array[input[inOffset + 2] & 0xFF];
            }
            case 2: 
        }
        b = pem_convert_array[input[inOffset + 1] & 0xFF];
        a = pem_convert_array[input[inOffset] & 0xFF];
        switch (rem) {
            case 2: {
                output[outOffset] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
                break;
            }
            case 3: {
                output[outOffset] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
                output[outOffset + 1] = (byte)(b << 4 & 0xF0 | c >>> 2 & 0xF);
                break;
            }
            default: {
                output[outOffset] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
                output[outOffset + 1] = (byte)(b << 4 & 0xF0 | c >>> 2 & 0xF);
                output[outOffset + 2] = (byte)(c << 6 & 0xC0 | d & 0x3F);
            }
        }
    }

    static {
        int i;
        pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        pem_convert_array = new byte[256];
        for (i = 0; i < 255; ++i) {
            Base64.pem_convert_array[i] = -1;
        }
        for (i = 0; i < pem_array.length; ++i) {
            Base64.pem_convert_array[Base64.pem_array[i]] = (byte)i;
        }
    }
}

