/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.Arrays;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.operamasks.faces.binding.factories.DelegatingDateTimeConverter;
import org.operamasks.faces.binding.impl.ConverterAdapter;

public class DateTimeFormatUtils {
    public static final String DEFAUTL_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String DEFAUTL_TIMEZONE = "GMT+8";
    public static final char SERVER_ESCAPED = '\\';
    public static final char CLIENT_ESCAPED = '\\';
    private static char[] CLIENT_DATE_PATTERNS = new char[]{'d', 'D', 'j', 'l', 'S', 'w', 'z', 'W', 'F', 'm', 'M', 'n', 'Y', 'y', 'A', 'g', 'G', 'h', 'H', 'i', 's', 'O'};
    private static String[] SERVER_DATE_PATTERNS = new String[]{"dd", "EEE", "d", "EEEE", "'th'", "E", "D", "w", "MMMM", "MM", "MMM", "M", "yyyy", "yy", "a", "h", "k", "hh", "HH", "mm", "ss", "Z"};
    private static char[] ESCAPE_NEEDED_SERVER_PATTERNS = new char[]{'d', 'E', 'D', 'w', 'M', 'a', 'h', 'k', 'Z'};
    private static char[] NOT_SUPPORTED_CLIENT_PATTERNS = new char[]{'t', 'N', 'L', 'o', 'a', 'u', 'P', 'T', 'Z', 'c', 'U'};

    public DateTimeFormatUtils() {
        Arrays.sort(CLIENT_DATE_PATTERNS);
        Arrays.sort(ESCAPE_NEEDED_SERVER_PATTERNS);
        Arrays.sort(NOT_SUPPORTED_CLIENT_PATTERNS);
    }

    public static String converToClientFormat(String serverFormat) {
        StringBuffer clientFormat = new StringBuffer();
        int pos = 0;
        while (pos < serverFormat.length()) {
            char c = serverFormat.charAt(pos);
            if (c == '\\' && pos < serverFormat.length() - 1) {
                char escaped;
                if (DateTimeFormatUtils.charInList(escaped = serverFormat.charAt(++pos), new char[][]{ESCAPE_NEEDED_SERVER_PATTERNS}) || escaped == '\\') {
                    if (DateTimeFormatUtils.charInList(escaped, CLIENT_DATE_PATTERNS, NOT_SUPPORTED_CLIENT_PATTERNS)) {
                        clientFormat.append('\\').append(escaped);
                    } else {
                        clientFormat.append(escaped);
                    }
                } else {
                    clientFormat.append('\\').append(escaped);
                }
                ++pos;
                continue;
            }
            int matched = DateTimeFormatUtils.bestMatchedPattern(serverFormat, pos);
            if (matched >= 0) {
                clientFormat.append(CLIENT_DATE_PATTERNS[matched]);
                pos += SERVER_DATE_PATTERNS[matched].length();
                continue;
            }
            if (DateTimeFormatUtils.charInList(c, CLIENT_DATE_PATTERNS, NOT_SUPPORTED_CLIENT_PATTERNS)) {
                clientFormat.append('\\');
            }
            clientFormat.append(serverFormat.charAt(pos));
            ++pos;
        }
        return clientFormat.toString();
    }

    private static boolean charInList(char c, char[] ... lists) {
        for (char[] list : lists) {
            if (Arrays.binarySearch(list, c) == -1) continue;
            return true;
        }
        return false;
    }

    private static int bestMatchedPattern(String source, int pos) {
        int len = 0;
        int matched = -1;
        for (int i = 0; i < SERVER_DATE_PATTERNS.length; ++i) {
            String candidate;
            int pLen = SERVER_DATE_PATTERNS[i].length();
            if (len >= pLen || pos + pLen > source.length() || !SERVER_DATE_PATTERNS[i].equals(candidate = source.substring(pos, pos + pLen))) continue;
            matched = i;
            len = pLen;
        }
        return matched;
    }

    public static String getPattenFromConverter(Converter converter) {
        ConverterAdapter ca;
        DelegatingDateTimeConverter dtc;
        if (converter instanceof DateTimeConverter) {
            DateTimeConverter dc = (DateTimeConverter)converter;
            return dc.getPattern();
        }
        if (converter instanceof ConverterAdapter && (dtc = (DelegatingDateTimeConverter)(ca = (ConverterAdapter)converter).getFallback()) != null) {
            return dtc.getPattern();
        }
        return null;
    }
}

