/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.operamasks.faces.application.StateAware;
import org.operamasks.faces.application.impl.TreeStructure;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.StateStub;
import org.operamasks.faces.util.DeepCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepCloneManager {
    private static final String ATTACHED_STATE_PARAM = "org.operamasks.faces.ATTACHED_STATE";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;

    public UIComponent deepCloneComponent(FacesContext context, UIComponent source) {
        TreeStructure treeStructure = this.buildTreeStructure(source);
        Object componentState = this.processSaveState(context, source);
        Object attachedState = this.getAttachedStateToSave(context);
        UIComponent component = null;
        if (treeStructure != null) {
            component = this.restoreTreeStructure(treeStructure);
        }
        if (component != null) {
            if (treeStructure instanceof Map) {
                this.restoreStateAwareTreeStructure(context, component, (Map)((Object)treeStructure));
            }
            if (componentState instanceof Map) {
                this.restoreOptimizedViewState(context, component, (Map)componentState);
            } else if (componentState != null) {
                this.processRestoreState(context, componentState, component);
            }
            if (attachedState != null) {
                this.setAttachedStateToRestore(context, attachedState);
            }
        }
        return component;
    }

    private Object processSaveState(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (component.isTransient()) {
            return null;
        }
        Object[] stateStruct = new Object[2];
        Object[] childState = EMPTY_ARRAY;
        if (component instanceof DeepCloneable) {
            DeepCloneable saveStatableComponent = (DeepCloneable)component;
            stateStruct[0] = saveStatableComponent.deepSaveState(context);
            int count = component.getChildCount() + component.getFacetCount();
            if (count > 0) {
                ArrayList<Object> stateList = new ArrayList<Object>(count);
                if (component.getChildCount() > 0) {
                    for (UIComponent kid : component.getChildren()) {
                        if (kid.isTransient()) continue;
                        if (kid instanceof DeepCloneable) {
                            stateList.add(this.processSaveState(context, kid));
                            continue;
                        }
                        stateList.add(kid.processSaveState(context));
                    }
                }
                if (component.getFacetCount() > 0) {
                    for (Map.Entry entry : component.getFacets().entrySet()) {
                        UIComponent facet = (UIComponent)entry.getValue();
                        if (facet.isTransient()) continue;
                        Object facetState = facet.processSaveState(context);
                        Object[] facetSaveState = new Object[]{entry.getKey(), facetState};
                        stateList.add(facetSaveState);
                    }
                }
                childState = stateList.toArray();
            }
            stateStruct[1] = childState;
            return stateStruct;
        }
        return null;
    }

    private void processRestoreState(FacesContext context, Object state, UIComponent component) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] stateStruct = (Object[])state;
        Object[] childState = (Object[])stateStruct[1];
        if (component instanceof DeepCloneable) {
            DeepCloneable saveStatableComponent = (DeepCloneable)component;
            saveStatableComponent.deepRestoreState(context, stateStruct[0]);
        } else {
            component.restoreState(context, stateStruct[0]);
        }
        int i = 0;
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                Object currentState;
                if (kid.isTransient() || (currentState = childState[i++]) == null) continue;
                if (kid instanceof DeepCloneable) {
                    this.processRestoreState(context, currentState, kid);
                    continue;
                }
                kid.processRestoreState(context, currentState);
            }
        }
    }

    private Object getAttachedStateToSave(FacesContext context) {
        Map stateMap = (Map)context.getExternalContext().getRequestMap().get(ATTACHED_STATE_PARAM);
        if (stateMap == null) {
            return null;
        }
        Object[] stateArray = new Object[stateMap.size() * 2];
        Iterator it = stateMap.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            stateArray[i * 2] = e.getKey();
            stateArray[i * 2 + 1] = UIComponentBase.saveAttachedState((FacesContext)context, e.getValue());
            ++i;
        }
        return stateArray;
    }

    private TreeStructure buildTreeStructure(UIComponent component) {
        TreeStructure struct = new TreeStructure(component);
        for (UIComponent uIComponent : component.getChildren()) {
            if (uIComponent.isTransient()) continue;
            TreeStructure childStruct = this.buildTreeStructure(uIComponent);
            struct.addChild(childStruct);
        }
        for (Map.Entry entry : component.getFacets().entrySet()) {
            UIComponent facet = (UIComponent)entry.getValue();
            if (facet.isTransient()) continue;
            TreeStructure facetStruct = this.buildTreeStructure(facet);
            struct.addFacet((String)entry.getKey(), facetStruct);
        }
        return struct;
    }

    private String saveStateInServer(FacesContext context, Object state, String key) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        sessionMap.put(key, state);
        return key;
    }

    private void setAttachedStateToRestore(FacesContext context, Object stateObj) {
        Object[] stateArray = (Object[])stateObj;
        HashMap<Object, Object> stateMap = new HashMap<Object, Object>(stateArray.length / 2);
        for (int i = 0; i < stateArray.length; i += 2) {
            Object key = stateArray[i];
            Object value = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)stateArray[i + 1]);
            stateMap.put(key, value);
        }
        context.getExternalContext().getRequestMap().put(ATTACHED_STATE_PARAM, stateMap);
    }

    private void restoreOptimizedViewState(FacesContext context, UIComponent component, Map stateMap) {
        Iterator<UIComponent> it = FacesUtils.createFacetsAndChildrenIterator(component, true);
        while (it.hasNext()) {
            Object state;
            UIComponent comp = it.next();
            if (comp.isTransient() || (state = stateMap.get(comp.getClientId(context))) == null) continue;
            if (comp instanceof StateAware) {
                ((StateAware)comp).restoreOptimizedState(context, state);
                continue;
            }
            comp.restoreState(context, state);
        }
    }

    private void restoreStateAwareTreeStructure(FacesContext context, UIComponent component, Map<String, TreeStructure> treeStrutureMap) {
        Iterator<UIComponent> it = FacesUtils.createFacetsAndChildrenIterator(component, true);
        while (it.hasNext()) {
            UIComponent newComp;
            TreeStructure struct;
            UIComponent comp = it.next();
            if (comp.isTransient() || !(comp instanceof StateStub) || (struct = treeStrutureMap.get(comp.getClientId(context))) == null || (newComp = this.restoreStateAwareTreeStructure(struct)) == null) continue;
            UIComponent parent = comp.getParent();
            parent.getChildren().remove(comp);
            parent.getChildren().add(newComp);
        }
    }

    private UIComponent restoreStateAwareTreeStructure(TreeStructure struct) {
        UIComponent component = struct.createComponent();
        component.setId(struct.getId());
        for (TreeStructure treeStructure : struct.getChildren()) {
            UIComponent child = this.restoreStateAwareTreeStructure(treeStructure);
            component.getChildren().add(child);
        }
        for (Map.Entry entry : struct.getFacets().entrySet()) {
            UIComponent facet = this.restoreStateAwareTreeStructure((TreeStructure)entry.getValue());
            component.getFacets().put(entry.getKey(), facet);
        }
        return component;
    }

    private UIComponent restoreTreeStructure(TreeStructure struct) {
        UIComponent component = struct.createComponent();
        for (TreeStructure treeStructure : struct.getChildren()) {
            UIComponent child = this.restoreTreeStructure(treeStructure);
            component.getChildren().add(child);
        }
        for (Map.Entry entry : struct.getFacets().entrySet()) {
            UIComponent facet = this.restoreTreeStructure((TreeStructure)entry.getValue());
            component.getFacets().put(entry.getKey(), facet);
        }
        return component;
    }
}

