/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.faces.model.DataModel;
import org.operamasks.org.json.simple.JSONArray;
import org.operamasks.org.json.simple.JSONObject;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtils {
    public static JSONArray writeDataModel(DataModel model) {
        JSONArray values = new JSONArray();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setRowIndex(i);
            JSONObject item = JSONUtils.writeBean(model.getRowData());
            if (item == null) continue;
            values.add(item);
        }
        return values;
    }

    public static JSONObject writeBean(Object bean) {
        if (bean == null) {
            return null;
        }
        JSONObject propObj = new JSONObject();
        Collection props = null;
        try {
            props = BeanUtils.getProperties(bean.getClass());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (props == null) {
            return null;
        }
        for (BeanProperty prop : props) {
            Method getter = prop.getReadMethod();
            if (getter == null) continue;
            try {
                Object propValue = getter.invoke(bean, new Object[0]);
                propObj.put(prop.getName(), propValue.toString());
            }
            catch (Exception e) {}
        }
        return propObj;
    }

    public static JSONObject writeObject(Map<String, Object> object) {
        if (object == null) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        jObject.putAll(object);
        return jObject;
    }
}

