/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.operamasks.faces.application.StateAware;

public class StateUtils {
    private static final String SERVER_STATE_KEY = "org.operamasks.faces.SERVER_TEMPLATE_STATE";

    public static void restoreSave(FacesContext context, String key, StateAware stateAware) {
        Map stateMap = StateUtils.getServerStateMap(context, false);
        Object value = null;
        if (stateMap != null) {
            value = stateMap.get(key);
        }
        if (value != null) {
            stateAware.restoreOptimizedState(context, value);
        } else if (stateMap != null) {
            stateMap.remove(key);
        }
    }

    public static void saveState(FacesContext context, String key, StateAware stateAware) {
        Object value = stateAware.saveOptimizedState(context);
        if (value != null) {
            Map stateMap = StateUtils.getServerStateMap(context, true);
            stateMap.put(key, value);
        } else {
            Map stateMap = StateUtils.getServerStateMap(context, false);
            if (stateMap != null) {
                stateMap.remove(key);
            }
        }
    }

    public static void removeState(FacesContext context, String key) {
        Map stateMap;
        if (key != null && (stateMap = StateUtils.getServerStateMap(context, false)) != null) {
            stateMap.remove(key);
        }
    }

    private static Map getServerStateMap(FacesContext ctx, boolean create) {
        ExternalContext ext = ctx.getExternalContext();
        if (ext.getSession(create) == null) {
            return null;
        }
        Map sessionMap = ext.getSessionMap();
        ConcurrentHashMap stateMap = (ConcurrentHashMap)sessionMap.get(SERVER_STATE_KEY);
        if (stateMap == null && create) {
            stateMap = new ConcurrentHashMap();
            sessionMap.put(SERVER_STATE_KEY, stateMap);
        }
        return stateMap;
    }
}

