/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.HiddenStateStub;
import org.operamasks.faces.internal.stub.component.HtmlHeadStub;
import org.operamasks.faces.internal.stub.component.HtmlPageStub;
import org.operamasks.faces.internal.stub.component.UseBeanStub;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureValidateUtils {
    private static Logger logger = LoggerUtil.getLogger("org.operamasks.faces.view");

    public static void validate(FacesContext context) {
        UIViewRoot root = context.getViewRoot();
        StructureValidateUtils.validateRootElements(root);
    }

    private static void validateRootElements(UIViewRoot root) {
        UIComponent unexpectedChild = StructureValidateUtils.pickUnexpectedChildByClass((UIComponent)root, HtmlPageStub.class, HtmlHeadStub.class, UseBeanStub.class, HiddenStateStub.class);
        if (unexpectedChild != null && logger.isLoggable(Level.FINE)) {
            logger.fine(Resources._T("UI_MISSING_PAGE_PARENT", FacesUtils.getComponentDesc(unexpectedChild)));
        }
    }

    public static UIComponent pickUnexpectedChildByClass(UIComponent parent, Class<?> ... childrenClasses) {
        for (UIComponent child : parent.getChildren()) {
            boolean pass = false;
            for (Class<?> childClass : childrenClasses) {
                if (!childClass.isAssignableFrom(child.getClass()) && !StructureValidateUtils.isLiteralText(child)) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            return child;
        }
        return null;
    }

    public static boolean isLiteralText(UIComponent component) {
        return "facelets.LiteralText".equals(component.getFamily());
    }
}

