/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.validator;

import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.validator.ClientValidator;
import org.operamasks.resources.Resources;

public class RegexpValidator
implements Validator,
ClientValidator,
StateHolder {
    public static final String VALIDATOR_ID = "org.operamasks.faces.Regexp";
    private String pattern;
    private String message;
    private boolean transientFlag = false;

    public RegexpValidator() {
    }

    public RegexpValidator(String pattern) {
        this.pattern = pattern;
    }

    public RegexpValidator(Pattern pattern) {
        this.pattern = pattern.pattern();
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setValue(String value) {
        this.setPattern(value);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null && this.pattern != null) {
            String converted = RegexpValidator.stringValue(value);
            if (!Pattern.compile(this.pattern).matcher(converted).matches()) {
                String message = this.message;
                if (message == null || message.length() == 0) {
                    message = Resources._T("JSF_VALIDATE_REGEXP_NOT_MATCH", FacesUtils.getLabel(context, component));
                }
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, message, null));
            }
        }
    }

    private static String stringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public String getValidatorScript(FacesContext context, UIComponent component) {
        return null;
    }

    public String getValidatorInstanceScript(FacesContext context, UIComponent component) {
        if (this.pattern == null) {
            return null;
        }
        String message = (String)component.getAttributes().get("validatorMessage");
        if (message == null && (message = this.message) == null) {
            message = Resources._T("JSF_VALIDATE_REGEXP_NOT_MATCH", FacesUtils.getLabel(context, component));
        }
        return String.format("new RegexpValidator(%s,%s)", HtmlEncoder.enquote(message), HtmlEncoder.enquote(this.pattern));
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[4];
        values[0] = this.pattern;
        values[1] = this.message;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.pattern = (String)values[0];
            this.message = (String)values[1];
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public String getPattern() {
        return this.pattern;
    }
}

