/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.webapp.core;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.Config;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.binding.ModelBindingFactory;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.render.ajax.AjaxRenderKitImpl;
import org.operamasks.faces.render.delegate.ViewDelegateManager;

public class ViewTag
extends UIComponentELTag {
    protected ValueExpression renderKitId;
    protected ValueExpression locale;
    protected MethodExpression beforePhase;
    protected MethodExpression afterPhase;
    private boolean redirected = false;

    public void setRenderKitId(ValueExpression renderKitId) {
        this.renderKitId = renderKitId;
    }

    public void setLocale(ValueExpression locale) {
        this.locale = locale;
    }

    public void setBeforePhase(MethodExpression beforePhase) {
        this.beforePhase = beforePhase;
    }

    public void setAfterPhase(MethodExpression afterPhase) {
        this.afterPhase = afterPhase;
    }

    public void setJspId(String id) {
        block2: {
            try {
                super.setJspId(id);
            }
            catch (RuntimeException ex) {
                if (FacesContext.getCurrentInstance() == null) break block2;
                throw ex;
            }
        }
    }

    public int doStartTag() throws JspException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            this.redirectToFacesServlet();
            this.redirected = true;
            return 0;
        }
        FacesUtils.beginView(context);
        int rc = super.doStartTag();
        this.pageContext.getResponse().setLocale(context.getViewRoot().getLocale());
        return rc;
    }

    public int doEndTag() throws JspException {
        if (this.redirected) {
            return 5;
        }
        int rc = super.doEndTag();
        FacesContext context = this.getFacesContext();
        boolean nested = FacesUtils.endView(context);
        if (nested) {
            return rc;
        }
        ModelBindingFactory.applyModelBindings(context, PhaseId.RENDER_RESPONSE);
        HttpSession session = this.pageContext.getSession();
        if (session != null) {
            String charset = this.pageContext.getResponse().getCharacterEncoding();
            session.setAttribute("javax.faces.request.charset", (Object)charset);
        }
        if (!AjaxRenderKitImpl.isAjaxResponse(context)) {
            UIViewRoot viewToRender = context.getViewRoot();
            ResponseWriter oldWriter = context.getResponseWriter();
            try {
                ResponseWriter writer;
                if (oldWriter != null) {
                    writer = oldWriter.cloneWithWriter((Writer)this.pageContext.getOut());
                } else {
                    RenderKit renderKit = context.getRenderKit();
                    writer = renderKit.createResponseWriter((Writer)this.pageContext.getOut(), null, null);
                }
                context.setResponseWriter(writer);
                ViewDelegateManager vdm = ViewDelegateManager.getInstance(context);
                if (vdm != null) {
                    vdm.processViewDelegates(context);
                }
                if (!context.getResponseComplete()) {
                    writer.startDocument();
                    viewToRender.encodeAll(context);
                    writer.endDocument();
                }
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
            finally {
                if (oldWriter != null) {
                    context.setResponseWriter(oldWriter);
                }
            }
        }
        return rc;
    }

    private void redirectToFacesServlet() throws JspException {
        ServletContext context = this.pageContext.getServletContext();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
        if (associate == null) {
            throw new JspException("Cannot find FacesServlet mapping");
        }
        String path = request.getServletPath();
        String facesPath = null;
        for (String mapping : associate.getFacesMappings()) {
            char c = mapping.charAt(0);
            if (c == '/') {
                facesPath = mapping.concat(path);
            } else if (c == '.') {
                int period = path.lastIndexOf(46);
                if (period == -1) {
                    facesPath = path.concat(mapping);
                } else if (!path.endsWith(mapping)) {
                    facesPath = path.substring(0, period).concat(mapping);
                }
            }
            if (facesPath != null) break;
        }
        if (facesPath == null) {
            throw new JspException("Cannot find FacesServlet mapping");
        }
        try {
            facesPath = context.getContextPath().concat(facesPath);
            response.sendRedirect(facesPath);
        }
        catch (Exception ex) {
            throw new JspException((Throwable)ex);
        }
    }

    public String getComponentType() {
        return null;
    }

    public String getRendererType() {
        return null;
    }

    protected UIComponent createComponent(FacesContext context, String newId) throws JspException {
        if (OMUtils.strict()) {
            throw new JspTagException("Nested view is not allowed");
        }
        Passthrough passthrough = new Passthrough();
        passthrough.setId(newId);
        return passthrough;
    }

    protected void setProperties(UIComponent component) {
        Locale loc;
        super.setProperties(component);
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = context.getViewRoot();
        if (this.renderKitId != null) {
            viewRoot.setValueExpression("renderKitId", this.renderKitId);
        } else if (viewRoot.getRenderKitId() == null) {
            String defaultRenderKitId = context.getApplication().getDefaultRenderKitId();
            if (defaultRenderKitId == null) {
                defaultRenderKitId = "HTML_BASIC";
            }
            viewRoot.setRenderKitId(defaultRenderKitId);
        }
        if (this.locale != null && (loc = OMUtils.getLocaleFromExpression(context, this.locale)) != null) {
            viewRoot.setLocale(loc);
            Config.set((ServletRequest)this.pageContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)loc);
        }
        if (this.beforePhase != null) {
            viewRoot.setBeforePhaseListener(this.beforePhase);
        }
        if (this.afterPhase != null) {
            viewRoot.setAfterPhaseListener(this.afterPhase);
        }
    }

    public static final class Passthrough
    extends UIComponentBase {
        public String getFamily() {
            return "org.operamasks.faces.Passthrough";
        }
    }
}

