/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.webapp.html;

import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.webapp.UIComponentELTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlBasicELTag
extends UIComponentELTag {
    private Map<String, ValueExpression> values;

    public void setValueExpression(String key, ValueExpression value) {
        assert (key != null);
        if (value == null) {
            this.removeValueExpression(key);
        } else {
            if (this.values == null) {
                this.values = new HashMap<String, ValueExpression>();
            }
            this.values.put(key, value);
        }
    }

    public ValueExpression getValueExpression(String key) {
        assert (key != null);
        if (this.values == null) {
            return null;
        }
        return this.values.get(key);
    }

    public void removeValueExpression(String key) {
        assert (key != null);
        if (this.values != null) {
            this.values.remove(key);
        }
    }

    public Map<String, ValueExpression> getValueExpressions() {
        if (this.values == null) {
            this.values = new HashMap<String, ValueExpression>();
        }
        return this.values;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        if (this.values != null) {
            for (Map.Entry<String, ValueExpression> e : this.values.entrySet()) {
                String name = e.getKey();
                ValueExpression value = e.getValue();
                if (value.getExpectedType() == Converter.class) {
                    this.setConverter(component, name, value);
                    continue;
                }
                component.setValueExpression(name, value);
            }
        }
    }

    protected void setConverter(UIComponent component, String name, ValueExpression converter) {
        if (converter.isLiteralText()) {
            String converterId = converter.getExpressionString();
            FacesContext context = FacesContext.getCurrentInstance();
            Converter conv = context.getApplication().createConverter(converterId);
            component.getAttributes().put(name, conv);
        } else {
            component.setValueExpression(name, converter);
        }
    }

    public void release() {
        super.release();
        if (this.values != null) {
            this.values.clear();
        }
        this.values = null;
    }
}

