/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.org.json.simple.parser;

import java.io.Reader;
import java.util.Stack;
import org.operamasks.org.json.simple.JSONArray;
import org.operamasks.org.json.simple.JSONObject;
import org.operamasks.org.json.simple.parser.Yylex;
import org.operamasks.org.json.simple.parser.Yytoken;

public class JSONParser {
    public static final int S_INIT = 0;
    public static final int S_IN_FINISHED_VALUE = 1;
    public static final int S_IN_OBJECT = 2;
    public static final int S_IN_ARRAY = 3;
    public static final int S_PASSED_PAIR_KEY = 4;
    public static final int S_IN_ERROR = -1;

    private int peekStatus(Stack statusStack) {
        if (statusStack.size() == 0) {
            return -1;
        }
        Integer status = (Integer)statusStack.peek();
        return status;
    }

    public Object parse(Reader in) throws Exception {
        Stack<Integer> statusStack = new Stack<Integer>();
        Stack<Object> valueStack = new Stack<Object>();
        Yylex lexer = new Yylex(in);
        Yytoken token = null;
        int status = 0;
        do {
            if ((token = lexer.yylex()) == null) {
                token = new Yytoken(-1, null);
            }
            block1 : switch (status) {
                case 0: {
                    switch (token.type) {
                        case 0: {
                            status = 1;
                            statusStack.push(status);
                            valueStack.push(token.value);
                            break block1;
                        }
                        case 1: {
                            status = 2;
                            statusStack.push(status);
                            valueStack.push(new JSONObject());
                            break block1;
                        }
                        case 3: {
                            status = 3;
                            statusStack.push(status);
                            valueStack.push(new JSONArray());
                            break block1;
                        }
                    }
                    status = -1;
                    break;
                }
                case 1: {
                    if (token.type == -1) {
                        return valueStack.pop();
                    }
                    return null;
                }
                case 2: {
                    String key;
                    switch (token.type) {
                        case 5: {
                            break block1;
                        }
                        case 0: {
                            if (token.value instanceof String) {
                                key = (String)token.value;
                                valueStack.push(key);
                                status = 4;
                                statusStack.push(status);
                                break block1;
                            }
                            status = -1;
                            break block1;
                        }
                        case 2: {
                            if (valueStack.size() > 1) {
                                statusStack.pop();
                                valueStack.pop();
                                status = this.peekStatus(statusStack);
                                break block1;
                            }
                            status = 1;
                            break block1;
                        }
                    }
                    status = -1;
                    break;
                }
                case 4: {
                    JSONArray newArray;
                    String key;
                    switch (token.type) {
                        case 6: {
                            break block1;
                        }
                        case 0: {
                            statusStack.pop();
                            key = (String)valueStack.pop();
                            JSONObject parent = (JSONObject)valueStack.peek();
                            parent.put(key, token.value);
                            status = this.peekStatus(statusStack);
                            break block1;
                        }
                        case 3: {
                            statusStack.pop();
                            key = (String)valueStack.pop();
                            JSONObject parent = (JSONObject)valueStack.peek();
                            newArray = new JSONArray();
                            parent.put(key, newArray);
                            status = 3;
                            statusStack.push(status);
                            valueStack.push(newArray);
                            break block1;
                        }
                        case 1: {
                            statusStack.pop();
                            key = (String)valueStack.pop();
                            JSONObject parent = (JSONObject)valueStack.peek();
                            JSONObject newObject = new JSONObject();
                            parent.put(key, newObject);
                            status = 2;
                            statusStack.push(status);
                            valueStack.push(newObject);
                            break block1;
                        }
                    }
                    status = -1;
                    break;
                }
                case 3: {
                    JSONArray newArray;
                    switch (token.type) {
                        case 5: {
                            break block1;
                        }
                        case 0: {
                            JSONArray val = (JSONArray)valueStack.peek();
                            val.add(token.value);
                            break block1;
                        }
                        case 4: {
                            if (valueStack.size() > 1) {
                                statusStack.pop();
                                valueStack.pop();
                                status = this.peekStatus(statusStack);
                                break block1;
                            }
                            status = 1;
                            break block1;
                        }
                        case 1: {
                            JSONArray val = (JSONArray)valueStack.peek();
                            JSONObject newObject = new JSONObject();
                            val.add(newObject);
                            status = 2;
                            statusStack.push(status);
                            valueStack.push(newObject);
                            break block1;
                        }
                        case 3: {
                            JSONArray val = (JSONArray)valueStack.peek();
                            newArray = new JSONArray();
                            val.add(newArray);
                            status = 3;
                            statusStack.push(status);
                            valueStack.push(newArray);
                            break block1;
                        }
                    }
                    status = -1;
                    break;
                }
                case -1: {
                    return null;
                }
            }
            if (status != -1) continue;
            return null;
        } while (token.type != -1);
        return null;
    }
}

