/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.g2recorder;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.util.Map;
import org.jfree.pixie.AbstractGraphics2D;
import org.jfree.pixie.g2recorder.AddRenderingHintsOperation;
import org.jfree.pixie.g2recorder.CopyAreaOperation;
import org.jfree.pixie.g2recorder.DrawImageOperation;
import org.jfree.pixie.g2recorder.DrawRenderedImageOperation;
import org.jfree.pixie.g2recorder.DrawShapeOperation;
import org.jfree.pixie.g2recorder.DrawStringOperation;
import org.jfree.pixie.g2recorder.FillShapeOperation;
import org.jfree.pixie.g2recorder.G2OpStore;
import org.jfree.pixie.g2recorder.G2Operation;
import org.jfree.pixie.g2recorder.SetBackgroundOperation;
import org.jfree.pixie.g2recorder.SetClipOperation;
import org.jfree.pixie.g2recorder.SetCompositeOperation;
import org.jfree.pixie.g2recorder.SetFontOperation;
import org.jfree.pixie.g2recorder.SetPaintModeOperation;
import org.jfree.pixie.g2recorder.SetPaintOperation;
import org.jfree.pixie.g2recorder.SetRenderingHintsOperation;
import org.jfree.pixie.g2recorder.SetStrokeOperation;
import org.jfree.pixie.g2recorder.SetTransformOperation;
import org.jfree.pixie.g2recorder.SetXORModeOperation;

public class G2Recorder
extends AbstractGraphics2D {
    private G2OpStore store;
    private Composite composite;
    private Paint paint;
    private Stroke stroke;
    private Color background;
    private AffineTransform transform;
    private Font font;
    private BufferedImage bimg;
    private Graphics2D dg2;
    private Area clip;

    public G2Recorder() {
        this.store = new G2OpStore();
        this.composite = AlphaComposite.getInstance(3);
        this.paint = Color.black;
        this.background = Color.white;
        this.stroke = new BasicStroke(0.1f);
        this.transform = AffineTransform.getTranslateInstance(0.0, 0.0);
        this.font = new Font("Serif", 0, 10);
        this.bimg = new BufferedImage(2, 2, 2);
        this.dg2 = this.bimg.createGraphics();
    }

    public G2Recorder(G2Recorder g2Recorder) {
        this.store = g2Recorder.getStore();
        this.bimg = g2Recorder.bimg;
        this.dg2 = (Graphics2D)g2Recorder.dg2.create();
        this.font = g2Recorder.font;
        this.transform = g2Recorder.transform;
        this.stroke = g2Recorder.stroke;
        this.background = g2Recorder.background;
        this.paint = g2Recorder.paint;
        this.composite = g2Recorder.composite;
    }

    protected void addOperation(G2Operation g2Operation) {
        this.store.addOperation(this, g2Operation);
    }

    public void addRenderingHints(Map map) {
        RenderingHints renderingHints = new RenderingHints(map);
        this.addOperation(new AddRenderingHintsOperation(renderingHints));
        this.dg2.addRenderingHints(renderingHints);
    }

    public void clip(Shape shape) {
        if (shape == null) {
            this.setClip(null);
            return;
        }
        shape = this.transform.createTransformedShape(shape);
        if (this.clip == null) {
            this.setClip(new Area(shape));
        } else {
            Area area = (Area)this.clip.clone();
            area.intersect(new Area(shape));
            this.setClip(area);
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.addOperation(new CopyAreaOperation(n, n2, n3, n4, n5, n6));
    }

    public Graphics create() {
        return new G2Recorder(this);
    }

    public void dispose() {
    }

    public void draw(Shape shape) {
        this.addOperation(new DrawShapeOperation(shape));
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.addOperation(new DrawImageOperation(image, affineTransform, imageObserver));
        return true;
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (affineTransform.getDeterminant() == 0.0) {
            return;
        }
        this.addOperation(new DrawRenderedImageOperation(renderedImage, affineTransform));
    }

    public void drawString(String string, float f, float f2) {
        this.addOperation(new DrawStringOperation(string, f, f2));
    }

    public void fill(Shape shape) {
        this.addOperation(new FillShapeOperation(shape));
    }

    public Color getBackground() {
        return this.background;
    }

    public Shape getClip() {
        return this.clip;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.dg2.getDeviceConfiguration();
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.dg2.getFontMetrics(font);
    }

    public FontRenderContext getFontRenderContext() {
        return this.dg2.getFontRenderContext();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.dg2.getRenderingHint(key);
    }

    public RenderingHints getRenderingHints() {
        return this.dg2.getRenderingHints();
    }

    public G2OpStore getStore() {
        return this.store;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setBackground(Color color) {
        this.addOperation(new SetBackgroundOperation(color));
        this.background = color;
    }

    public void setClip(Shape shape) {
        this.addOperation(new SetClipOperation(shape));
        this.clip = new Area(shape);
    }

    public void setComposite(Composite composite) {
        this.addOperation(new SetCompositeOperation(composite));
        this.composite = composite;
    }

    public void setFont(Font font) {
        this.addOperation(new SetFontOperation(font));
        this.font = font;
    }

    public void setPaint(Paint paint) {
        this.addOperation(new SetPaintOperation(paint));
        this.paint = paint;
    }

    public void setPaintMode() {
        this.addOperation(new SetPaintModeOperation());
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public void setRenderingHints(Map map) {
        RenderingHints renderingHints = new RenderingHints(map);
        this.addOperation(new SetRenderingHintsOperation(renderingHints));
        this.dg2.setRenderingHints(renderingHints);
    }

    public void setStroke(Stroke stroke) {
        this.addOperation(new SetStrokeOperation(stroke));
        this.stroke = stroke;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.addOperation(new SetTransformOperation(affineTransform));
        this.transform = affineTransform;
    }

    public void setXORMode(Color color) {
        this.addOperation(new SetXORModeOperation(color));
    }
}

