/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.io.IOException;
import java.io.InputStream;
import org.jfree.pixie.wmf.Buffer;
import org.jfree.pixie.wmf.MfType;

public class MfRecord
extends Buffer {
    public static int RECORD_HEADER_SIZE = 6;
    private static int RECORD_TYPE_POS = 4;
    private MfType type = null;

    public MfRecord(int n) {
        super(n * 2 + RECORD_HEADER_SIZE);
    }

    public MfRecord(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public boolean doesMark() {
        return this.type.doesMark();
    }

    public int getLongParam(int n) {
        return this.getInt(n * 2 + RECORD_HEADER_SIZE);
    }

    public String getName() {
        return this.type.getName();
    }

    public int getParam(int n) {
        return this.getShort(n * 2 + RECORD_HEADER_SIZE);
    }

    public String getStringParam(int n, int n2) {
        return this.getString(n * 2 + RECORD_HEADER_SIZE, n2);
    }

    public int getType() {
        return this.getShort(RECORD_TYPE_POS);
    }

    public boolean isMappingMode() {
        return this.type.isMappingMode();
    }

    protected void read(InputStream inputStream) throws IOException {
        super.read(inputStream, 0, RECORD_HEADER_SIZE);
        int n = this.getInt(0) * 2 - RECORD_HEADER_SIZE;
        if (n > 0) {
            super.read(inputStream, RECORD_HEADER_SIZE, n);
        }
        this.type = MfType.get(this.getType());
    }

    public void setLongParam(int n, int n2) {
        this.setInt(n * 2 + RECORD_HEADER_SIZE, n2);
    }

    public void setParam(int n, int n2) {
        this.setShort(n * 2 + RECORD_HEADER_SIZE, n2);
    }

    public void setStringParam(int n, String string) {
        this.setString(n * 2 + RECORD_HEADER_SIZE, string);
    }

    public void setType(int n) {
        this.setShort(RECORD_TYPE_POS, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        stringBuffer.append(": ");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = (this.getInt(0) - 3) * 2;
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 16 == 0) {
                stringBuffer.append("\n");
                stringBuffer2.append("\n");
            } else if (n2 % 8 == 0) {
                stringBuffer.append(" ");
            }
            int n3 = this.getByte(n2 + RECORD_HEADER_SIZE);
            if (n3 < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(" ");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

