/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.jfree.pixie.wmf.WmfFile;

public class WmfImageProducer
implements ImageProducer {
    private WmfFile metafile;
    private ArrayList consumers = new ArrayList();

    public WmfImageProducer(String string, int n, int n2) throws IOException {
        this.metafile = new WmfFile(string, n, n2);
    }

    public WmfImageProducer(URL uRL) throws IOException {
        this.metafile = new WmfFile(uRL);
    }

    public WmfImageProducer(URL uRL, int n, int n2) throws IOException {
        this.metafile = new WmfFile(uRL, n, n2);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            return;
        }
        this.consumers.add(imageConsumer);
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ((AbstractCollection)this.consumers).remove(imageConsumer);
    }

    public synchronized void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public synchronized void startProduction(ImageConsumer imageConsumer) {
        int n;
        if (imageConsumer != null) {
            this.addConsumer(imageConsumer);
        }
        ImageConsumer[] imageConsumerArray = this.consumers.toArray(new ImageConsumer[this.consumers.size()]);
        BufferedImage bufferedImage = this.metafile.replay();
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n4 = 0;
        while (n4 < imageConsumerArray.length) {
            ImageConsumer imageConsumer2 = imageConsumerArray[n4];
            imageConsumer2.setHints(2);
            imageConsumer2.setHints(16);
            imageConsumer2.setHints(8);
            imageConsumer2.setHints(4);
            imageConsumer2.setDimensions(n2, n3);
            imageConsumer2.setColorModel(colorModel);
            ++n4;
        }
        int n5 = 10;
        int[] nArray = new int[n2 * 10];
        int n6 = 0;
        while (n6 < n3) {
            n = 0;
            n = n6 + 10 > n3 ? n3 - n6 : 10;
            nArray = bufferedImage.getRGB(0, n6, n2, n, nArray, 0, n2);
            int n7 = 0;
            while (n7 < imageConsumerArray.length) {
                ImageConsumer imageConsumer3 = imageConsumerArray[n7];
                imageConsumer3.setPixels(0, n6, n2, n, colorModel, nArray, 0, n2);
                ++n7;
            }
            n6 += 10;
        }
        n = 0;
        while (n < imageConsumerArray.length) {
            ImageConsumer imageConsumer4 = imageConsumerArray[n];
            imageConsumer4.imageComplete(3);
            ++n;
        }
        if (imageConsumer != null) {
            this.removeConsumer(imageConsumer);
        }
    }
}

