/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.bitmap;

import java.io.IOException;
import java.io.InputStream;
import org.jfree.pixie.wmf.bitmap.GDIPalette;

public abstract class BitmapCompression {
    private int height;
    private int width;
    private int bpp;
    private boolean topDown;

    public abstract int[] decompress(InputStream var1, GDIPalette var2) throws IOException;

    public static int[] expand4BitTuple(int n, GDIPalette gDIPalette) {
        int[] nArray = new int[]{gDIPalette.lookupColor((n & 0xF0) >> 4), gDIPalette.lookupColor(n & 0xF)};
        return nArray;
    }

    public static int[] expandMonocrome(int n, GDIPalette gDIPalette) {
        int n2 = gDIPalette.lookupColor(1);
        int n3 = gDIPalette.lookupColor(0);
        int[] nArray = new int[]{(n & 1) == 1 ? n2 : n3, (n & 2) == 2 ? n2 : n3, (n & 4) == 4 ? n2 : n3, (n & 8) == 8 ? n2 : n3, (n & 0x10) == 16 ? n2 : n3, (n & 0x20) == 32 ? n2 : n3, (n & 0x40) == 64 ? n2 : n3, (n & 0x80) == 128 ? n2 : n3};
        return nArray;
    }

    public int getBpp() {
        return this.bpp;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isTopDown() {
        return this.topDown;
    }

    public void setBpp(int n) {
        this.bpp = n;
    }

    public void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setTopDown(boolean bl) {
        this.topDown = bl;
    }
}

