/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.bitmap;

import org.jfree.pixie.wmf.MfRecord;

public class BitmapHeader {
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    private int BMPH_DATA_OFFSET = MfRecord.RECORD_HEADER_SIZE;
    private int BMPH_HEADERSIZE = MfRecord.RECORD_HEADER_SIZE + 4;
    private int BMPH_WIDTH = MfRecord.RECORD_HEADER_SIZE + 8;
    private int BMPH_HEIGHT = MfRecord.RECORD_HEADER_SIZE + 12;
    private int BMPH_NO_PLANES = MfRecord.RECORD_HEADER_SIZE + 14;
    private int BMPH_BPP = MfRecord.RECORD_HEADER_SIZE + 16;
    private int BMPH_COMPRESSION = MfRecord.RECORD_HEADER_SIZE + 20;
    private int BMPH_DATASIZE = MfRecord.RECORD_HEADER_SIZE + 24;
    private int BMPH_HRES = MfRecord.RECORD_HEADER_SIZE + 28;
    private int BMPH_VRES = MfRecord.RECORD_HEADER_SIZE + 32;
    private int BMPH_NO_COLORS = MfRecord.RECORD_HEADER_SIZE + 36;
    private int BMPH_NO_IMPORTANT_COLORS = MfRecord.RECORD_HEADER_SIZE + 40;
    private int dataOffset;
    private int headerSize;
    private int width;
    private int height;
    private int noPlanes;
    private int bitPerPixel;
    private int compression;
    private int dataSize;
    private int hres;
    private int vres;
    private int noColors;
    private int noImportantColors;
    private boolean isTopDown;

    private void fixPalette() {
        if (this.bitPerPixel < 16) {
            if (this.noColors == 0) {
                this.noColors = (int)Math.pow(2.0, this.bitPerPixel);
            }
            if (this.noImportantColors == 0) {
                this.noImportantColors = (int)Math.pow(2.0, this.bitPerPixel);
            }
        }
    }

    public int getBitsPerPixel() {
        return this.bitPerPixel;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getHRes() {
        return this.hres;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNoOfColors() {
        return this.noColors;
    }

    public int getNoOfImportantColors() {
        return this.noImportantColors;
    }

    public int getNoPlanes() {
        return this.noPlanes;
    }

    public int getVRes() {
        return this.vres;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isTopDown() {
        return this.isTopDown;
    }

    public void setRecord(MfRecord mfRecord, int n) {
        this.dataOffset = mfRecord.getInt(n + this.BMPH_DATA_OFFSET);
        this.headerSize = mfRecord.getInt(n + this.BMPH_HEADERSIZE);
        this.width = mfRecord.getInt(n + this.BMPH_WIDTH);
        this.height = mfRecord.getInt(n + this.BMPH_HEIGHT);
        this.noPlanes = mfRecord.getShort(n + this.BMPH_NO_PLANES);
        this.bitPerPixel = mfRecord.getShort(n + this.BMPH_BPP);
        this.compression = mfRecord.getInt(n + this.BMPH_COMPRESSION);
        this.dataSize = mfRecord.getInt(n + this.BMPH_DATASIZE);
        this.hres = mfRecord.getInt(n + this.BMPH_HRES);
        this.vres = mfRecord.getInt(n + this.BMPH_VRES);
        this.noColors = mfRecord.getInt(n + this.BMPH_NO_COLORS);
        this.noImportantColors = mfRecord.getInt(n + this.BMPH_NO_IMPORTANT_COLORS);
        if (this.height < 0) {
            this.isTopDown = true;
            this.height = -this.height;
        }
        this.fixPalette();
    }
}

