/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.bitmap;

import java.io.IOException;
import java.io.InputStream;

public class GDIPalette {
    private int noColors = 0;
    private int[] colors = null;

    public int lookupColor(int n) {
        if (this.noColors == 0) {
            int n2 = (n & 0xFF0000) >> 16;
            int n3 = n & 0xFF00;
            int n4 = n & 0xFF;
            return n2 + n3 + (n4 << 16);
        }
        return this.colors[n];
    }

    private int readNextColor(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        inputStream.read();
        return n + (n2 << 8) + (n3 << 16);
    }

    public void readPalette(InputStream inputStream) throws IOException {
        this.colors = new int[this.noColors];
        int n = 0;
        while (n < this.noColors) {
            this.colors[n] = this.readNextColor(inputStream);
            ++n;
        }
    }

    public void setNoOfColors(int n) {
        this.noColors = n;
    }

    public void setNoOfImportantColors(int n) {
        if (n > this.noColors) {
            throw new IllegalArgumentException("There may be not more important colors than colors defined in the palette.");
        }
    }
}

