/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.bitmap;

import java.io.IOException;
import java.io.InputStream;
import org.jfree.pixie.wmf.bitmap.BitmapCompression;
import org.jfree.pixie.wmf.bitmap.GDIPalette;

public class RGBCompression
extends BitmapCompression {
    public int[] decompress(InputStream inputStream, GDIPalette gDIPalette) throws IOException {
        int[] nArray = new int[this.getWidth() * this.getHeight()];
        switch (this.getBpp()) {
            case 1: {
                this.fillMono(nArray, inputStream, gDIPalette);
                break;
            }
            case 4: {
                this.fill4Bit(nArray, inputStream, gDIPalette);
                break;
            }
            case 8: {
                this.fill8Bit(nArray, inputStream, gDIPalette);
                break;
            }
            case 16: {
                this.fill16Bit(nArray, inputStream, gDIPalette);
                break;
            }
            case 24: {
                this.fill24Bit(nArray, inputStream, gDIPalette);
                break;
            }
            case 32: {
                this.fill32Bit(nArray, inputStream, gDIPalette);
                break;
            }
        }
        return nArray;
    }

    public void fill16Bit(int[] nArray, InputStream inputStream, GDIPalette gDIPalette) throws IOException {
        int n = nArray.length * 2;
        if (!this.isTopDown()) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = inputStream.read();
                if (n3 == -1) {
                    return;
                }
                int n4 = inputStream.read();
                if (n4 == -1) {
                    return;
                }
                nArray[n2] = gDIPalette.lookupColor((n4 << 8) + n3);
                --n2;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                int n6 = inputStream.read();
                if (n6 == -1) {
                    return;
                }
                int n7 = inputStream.read();
                if (n7 == -1) {
                    return;
                }
                nArray[n5] = gDIPalette.lookupColor((n7 << 8) + n6);
                ++n5;
            }
        }
    }

    public void fill24Bit(int[] nArray, InputStream inputStream, GDIPalette gDIPalette) throws IOException {
        int n = nArray.length * 4;
        if (!this.isTopDown()) {
            int n2 = n - 1;
            while (n2 >= 0) {
                nArray[n2] = gDIPalette.lookupColor(this.readInt(inputStream));
                --n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                nArray[n3] = gDIPalette.lookupColor(this.readInt(inputStream));
                ++n3;
            }
        }
    }

    public void fill32Bit(int[] nArray, InputStream inputStream, GDIPalette gDIPalette) throws IOException {
        int n = nArray.length * 4;
        if (!this.isTopDown()) {
            int n2 = n - 1;
            while (n2 >= 0) {
                nArray[n2] = gDIPalette.lookupColor(this.readInt(inputStream));
                --n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                nArray[n3] = gDIPalette.lookupColor(this.readInt(inputStream));
                ++n3;
            }
        }
    }

    public void fill4Bit(int[] nArray, InputStream inputStream, GDIPalette gDIPalette) throws IOException {
        int n = (int)Math.ceil(nArray.length / 2);
        if (!this.isTopDown()) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = inputStream.read();
                if (n3 == -1) {
                    return;
                }
                int[] nArray2 = BitmapCompression.expand4BitTuple(n3, gDIPalette);
                nArray[n2 * 2] = nArray2[1];
                nArray[n2 * 2 + 1] = nArray2[0];
                --n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                int n5 = inputStream.read();
                if (n5 == -1) {
                    return;
                }
                int[] nArray3 = BitmapCompression.expand4BitTuple(n5, gDIPalette);
                nArray[n4 * 2] = nArray3[0];
                nArray[n4 * 2 + 1] = nArray3[1];
                ++n4;
            }
        }
    }

    public void fill8Bit(int[] nArray, InputStream inputStream, GDIPalette gDIPalette) throws IOException {
        int n = nArray.length;
        if (!this.isTopDown()) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = inputStream.read();
                if (n3 == -1) {
                    return;
                }
                nArray[n2] = gDIPalette.lookupColor(n3);
                --n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                int n5 = inputStream.read();
                if (n5 == -1) {
                    return;
                }
                nArray[n4] = gDIPalette.lookupColor(n5);
                ++n4;
            }
        }
    }

    public void fillMono(int[] nArray, InputStream inputStream, GDIPalette gDIPalette) throws IOException {
        int n = (int)Math.ceil(nArray.length / 8);
        if (!this.isTopDown()) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = this.readInt(inputStream);
                if (n3 == -1) {
                    return;
                }
                int[] nArray2 = BitmapCompression.expandMonocrome(n3, gDIPalette);
                int n4 = nArray.length - n2 * 8;
                int n5 = Math.min(8, n4);
                int n6 = n5 - 1;
                while (n6 >= 0) {
                    nArray[7 - n6 + n2 * 8] = nArray2[n6];
                    --n6;
                }
                --n2;
            }
        } else {
            int n7 = 0;
            while (n7 < n) {
                int n8 = this.readInt(inputStream);
                if (n8 == -1) {
                    return;
                }
                int[] nArray3 = BitmapCompression.expandMonocrome(n8, gDIPalette);
                int n9 = 0;
                while (n9 < 8) {
                    nArray[n9 + n7 * 8] = nArray3[n9];
                    ++n9;
                }
                ++n7;
            }
        }
    }

    public static String forceToSizeLeft(String string, int n, char c) {
        if (string != null && string.length() == n) {
            return string;
        }
        StringBuffer stringBuffer = string == null ? new StringBuffer(n) : new StringBuffer(string);
        if (stringBuffer.length() > n) {
            stringBuffer.setLength(n);
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer2 = new StringBuffer(n);
        int n2 = n - stringBuffer.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = c;
            ++n3;
        }
        stringBuffer2.append(cArray);
        stringBuffer2.append((Object)stringBuffer);
        return stringBuffer2.toString();
    }

    protected int readInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            return -1;
        }
        int n2 = inputStream.read();
        if (n2 == -1) {
            return -1;
        }
        int n3 = inputStream.read();
        if (n3 == -1) {
            return -1;
        }
        int n4 = inputStream.read();
        if (n4 == -1) {
            return -1;
        }
        int n5 = (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        return n5;
    }
}

